/**********************************************/
/* Evert Glebbeek 2003                        */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include <string.h>
#include <stdio.h>
#include "mapdraw.h"
#include "maptile.h"
#include "tiles.h"
#include "map.h"
#include "gfx.h"

static BITMAP *backbuffer = NULL;
static BITMAP *connected_info = NULL;

void map_draw_initialize(void)
{
   ASSERT(backbuffer==NULL);
   
   backbuffer = create_optimized_bitmap(MAP_WIDTH*TILE_WIDTH, MAP_HEIGHT*TILE_HEIGHT);
   connected_info = create_bitmap(6,6);
   clear_bitmap(connected_info);
   
   ASSERT(backbuffer);
   ASSERT(connected_info);
}

void map_draw_shutdown(void)
{
   destroy_bitmap(backbuffer);
   destroy_bitmap(connected_info);

   backbuffer = NULL;
   connected_info = NULL;   
}

BITMAP *get_connect_info_bitmap(void)
{
   return connected_info;
}

int tile_is_visible(int tx, int ty)
{
   return getpixel(connected_info, (tx)/((MAP_WIDTH)/4)+1, (ty-1)/((MAP_HEIGHT)/4)+1)!=0;
}

static int read_tilemap(int *tilemap, int tx, int ty)
{
   if (tile_is_visible(tx,ty)) {
      return tilemap[TILE_INDEX(tx,ty)];
   } else {
      return MAP_CEILING;
   }
}

void render_tilemap(int *tm, int *doorsleft, int *doorsright)
{
   int tile;
   int x, y;
   int c;
   
   clear_bitmap(backbuffer);
   
   /* Draw basic terrain */
   for (x=0; x<MAP_WIDTH; x++) {
      for (y=0; y<MAP_HEIGHT; y++) {
         tile = read_tilemap(tm, x, y);
         switch (tile) {
            case MAP_FLOOR:
               blit(get_tile_bitmap(FLOOR1_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               /* Transitions */
               c = 0;
               if (read_tilemap(tm, x-1,y)==MAP_WALL)
                  c|=1;
               if (read_tilemap(tm, x,y-1)==MAP_WALL)
                  c|=2;
               if (read_tilemap(tm, x+1,y)==MAP_WALL)
                  c|=4;
               if (read_tilemap(tm, x,y+1)==MAP_WALL)
                  c|=8;
               if (c) {
                  masked_blit(get_tile_bitmap(BOR01_PCX+c-1), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               } else {
                  c = 0;
                  if (read_tilemap(tm, x-1,y-1)==MAP_WALL)
                     c|=1;
                  if (read_tilemap(tm, x+1,y-1)==MAP_WALL)
                     c|=2;
                  if (read_tilemap(tm, x+1,y+1)==MAP_WALL)
                     c|=4;
                  if (read_tilemap(tm, x-1,y+1)==MAP_WALL)
                     c|=8;
                  if (c) {
                     masked_blit(get_tile_bitmap(COR01_PCX+c-1), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                  }
               }
               break;
            case MAP_WALL|MAP_DOOR:
               if (read_tilemap(tm, x-1,y)==MAP_FLOOR) {
                  masked_blit(get_tile_bitmap(CAVE1R_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               } else if (read_tilemap(tm, x,y-1)==MAP_FLOOR) {
                  masked_blit(get_tile_bitmap(CAVE1B_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               } else if (read_tilemap(tm, x+1,y)==MAP_FLOOR) {
                  masked_blit(get_tile_bitmap(CAVE1L_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               } else if (read_tilemap(tm, x,y+1)==MAP_FLOOR) {
                  masked_blit(get_tile_bitmap(CAVE1T_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               }
               break;
            case MAP_WALL:
               /* Orientation of the wall */
               if (read_tilemap(tm, x-1,y)&MAP_WALL) {
                  if (read_tilemap(tm, x+1,y)&MAP_WALL) {
                     if (read_tilemap(tm, x,y+1)==MAP_FLOOR)
                        blit(get_tile_bitmap(WALL_T_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                     else
                        blit(get_tile_bitmap(WALL_B_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                  }
               } else if (read_tilemap(tm, x,y-1)&MAP_WALL) {
                  if (read_tilemap(tm, x,y+1)&MAP_WALL) {
                     if (read_tilemap(tm, x+1,y)==MAP_FLOOR)
                        blit(get_tile_bitmap(WALL_L_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                     else
                        blit(get_tile_bitmap(WALL_R_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                  }
               }
               /* Corners */
               if (read_tilemap(tm, x-1,y)==MAP_WALL && read_tilemap(tm, x,y-1)==MAP_WALL) {
                  if (read_tilemap(tm, x+1,y)==MAP_CEILING && read_tilemap(tm, x,y+1)==MAP_CEILING)
                     blit(get_tile_bitmap(WALLC_LRB_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                  else
                     blit(get_tile_bitmap(WALLC_ULF_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               } else if (read_tilemap(tm, x-1,y)==MAP_WALL && read_tilemap(tm, x,y+1)==MAP_WALL) {
                  if (read_tilemap(tm, x+1,y)==MAP_CEILING && read_tilemap(tm, x,y-1)==MAP_CEILING)
                     blit(get_tile_bitmap(WALLC_URB_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                  else
                     blit(get_tile_bitmap(WALLC_LLF_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               } else if (read_tilemap(tm, x+1,y)==MAP_WALL && read_tilemap(tm, x,y-1)==MAP_WALL) {
                  if (read_tilemap(tm, x-1,y)==MAP_CEILING && read_tilemap(tm, x,y+1)==MAP_CEILING)
                     blit(get_tile_bitmap(WALLC_LLB_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                  else
                     blit(get_tile_bitmap(WALLC_URF_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               } else if (read_tilemap(tm, x+1,y)==MAP_WALL && read_tilemap(tm, x,y+1)==MAP_WALL) {
                  if (read_tilemap(tm, x-1,y)==MAP_CEILING && read_tilemap(tm, x,y-1)==MAP_CEILING)
                     blit(get_tile_bitmap(WALLC_ULB_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                  else
                     blit(get_tile_bitmap(WALLC_LRF_PCX), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               }
               break;
            case MAP_CEILING:
               rectfill(backbuffer, x*TILE_WIDTH, y*TILE_WIDTH, (x+1)*TILE_WIDTH, (y+1)*TILE_WIDTH, black);
               /* Transitions */
               c = 0;
               if ((x>0) && read_tilemap(tm, x-1,y)&MAP_WALL)
                  c|=1;
               if ((y>0) && read_tilemap(tm, x,y-1)&MAP_WALL)
                  c|=2;
               if ((x<MAP_WIDTH-1) && read_tilemap(tm, x+1,y)&MAP_WALL)
                  c|=4;
               if ((y<MAP_HEIGHT-1) && read_tilemap(tm, x,y+1)&MAP_WALL)
                  c|=8;
               if (c) {
                  masked_blit(get_tile_bitmap(WTOP01_PCX+c-1), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                  c = 0;
               } else {
                  c = 0;
                  if (read_tilemap(tm, x-1,y-1)&MAP_WALL)
                     c|=1;
                  if (read_tilemap(tm, x+1,y-1)&MAP_WALL)
                     c|=2;
                  if (read_tilemap(tm, x+1,y+1)&MAP_WALL)
                     c|=4;
                  if (read_tilemap(tm, x-1,y+1)&MAP_WALL)
                     c|=8;
                  if (c) {
                     masked_blit(get_tile_bitmap(WCOR01_PCX+c-1), backbuffer, 0,0, x*TILE_WIDTH, y*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
                  }
               }
               break;
            default:
               rectfill(backbuffer, x*TILE_WIDTH, y*TILE_WIDTH, (x+1)*TILE_WIDTH, (y+1)*TILE_WIDTH, black);
               break;
         }
      }
   }
   
   /* Draw doors */
   for (c=0; c<4; c++) {
      if (tile_is_visible(1, 8+c*15)) {
         switch(doorsleft[c]) {
            case MAP_DOOR_LOCKED:
               masked_blit(get_tile_bitmap(DOOR1L_PCX), backbuffer, 0,0, 
                           1*TILE_WIDTH, (8+c*15)*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               break;
            case MAP_DOOR_BLOCKED:
               masked_blit(get_tile_bitmap(WALLCR_L_PCX), backbuffer, 0,0, 
                           1*TILE_WIDTH, (8+c*15)*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               break;
            case MAP_DOOR_SWITCH2:
               if (get_switch_state()!=0)
                  masked_blit(get_tile_bitmap(DOOR8L_PCX), backbuffer, 0,0, 
                              1*TILE_WIDTH, (8+c*15)*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               break;
            case MAP_DOOR_CREATUREL:
            case MAP_DOOR_CREATURE:
               masked_blit(get_tile_bitmap(DOOR8L_PCX), backbuffer, 0,0, 
                           1*TILE_WIDTH, (8+c*15)*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               break;
            case MAP_DOOR_SWITCH:
               if (get_switch_state()==0)
                  masked_blit(get_tile_bitmap(DOOR8L_PCX), backbuffer, 0,0, 
                              1*TILE_WIDTH, (8+c*15)*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               break;
         }
      }

      if (tile_is_visible((MAP_WIDTH-2), 8+c*15)) {
         switch(doorsright[c]) {
            case MAP_DOOR_LOCKED:
               masked_blit(get_tile_bitmap(DOOR1R_PCX), backbuffer, 0,0, 
                           (MAP_WIDTH-2)*TILE_WIDTH, (8+c*15)*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               break;
            case MAP_DOOR_BLOCKED:
               masked_blit(get_tile_bitmap(WALLCR_R_PCX), backbuffer, 0,0, 
                           (MAP_WIDTH-2)*TILE_WIDTH, (8+c*15)*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               break;
            case MAP_DOOR_SWITCH2:
               if (get_switch_state()!=0)
                  masked_blit(get_tile_bitmap(DOOR8R_PCX), backbuffer, 0,0, 
                              (MAP_WIDTH-2)*TILE_WIDTH, (8+c*15)*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               break;
            case MAP_DOOR_CREATURER:
            case MAP_DOOR_CREATURE:
               masked_blit(get_tile_bitmap(DOOR8R_PCX), backbuffer, 0,0, 
                           (MAP_WIDTH-2)*TILE_WIDTH, (8+c*15)*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               break;
            case MAP_DOOR_SWITCH:
               if (get_switch_state()==0)
                  masked_blit(get_tile_bitmap(DOOR8R_PCX), backbuffer, 0,0, 
                              (MAP_WIDTH-2)*TILE_WIDTH, (8+c*15)*TILE_WIDTH, TILE_WIDTH, TILE_HEIGHT);
               break;
         }
      }
   }
}

void blit_backbuffer(BITMAP *bmp, int destx, int desty, int x1, int y1, int w, int h)
{
   blit(backbuffer, bmp, x1, y1, destx, desty, w, h);
   //stretch_blit(connected_info, bmp, 0,0, 6,6, destx, desty, 60,60);
}
