//GIFAllegS ver 1.00
//By Hard Rock
//http://stars.hybd.net, hard_rock_2@yahoo.com
#ifndef _GIF_H_
#define _GIF_H_

#ifdef __cplusplus
   extern "C" {
#endif

#define DAT_GIF  DAT_ID('G','I','F',' ')
#define DAT_GIFA  DAT_ID('G','I','F','A')
//Gif gif_a_setttings these values
#define GIF_A_IGNOREBACKGROUND 1 //Ingores Background color when loading
#define GIF_A_NOGLOBALPAL    2 //When Saving a global pal is used
#define GIF_A_SAVEINTERLACED   4 //Saves a gif interlaced
#define GIF_A_NOTRANS           8 //No Tranpsarent Colour
#define GIF_SETBACKGROUND(a) gif_a_settings |= ((char)a) << 3 //Sets the background when writing gif
/////////////////////////////////////////////////
//LZW section
//This is our table
typedef struct LZW_STRUCT
{
    //The actual LZW table
    unsigned short int *prefix; //The Prefix, first code
    short int  *character;  //The char that is added to a code, always -1-255 so no need for unsigned
    unsigned short int codes_used;    //How many CODES of Size are used
    unsigned short int codes_reserved; //Which codes not used, usually 0-255 for ASCII
    unsigned short int lzw_size;      //Tells us how many LZW's were allocated
    
    //This is for Write and Get codes
    unsigned int buffer;     //32 bits of space, up to 16bit compression
    char buffer_bits;        //lets save some mem, we dont need a compression greater than 128 bits.
    int bits;                //How many bits per code
    unsigned short int buffer_size; //Used for gif, and other possible lzw implentations
    unsigned short int to_nbuffer;  //Used for gif, how much before new buffer must be allocated
    
    //The string buffer
    unsigned char *string;
}LZW;


//These are all related to memory managment of the LZW table
int create_lzw_table (LZW *table, int bits);
int delete_lzw_table (LZW *table);
int clear_lzw_table(LZW *table);
int clear_lzw_tablef(LZW *table,int bits);

//Get String, and finds any available code, internal use
int lzw_get_string(LZW *table, int code_number);
int lzw_find_code(LZW *table, int string_buffer, int character);
/////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////
//Gif Code
//Returned from a data file
typedef struct GIF_STRUCT
{
BITMAP *image;
PALETTE pal;
}GIF;

//Same as above except with more a next element
typedef struct GIF_FRAME_STRUCT
{
BITMAP *image;
PALETTE pal;
unsigned short int delay;
struct GIF_FRAME_STRUCT *next;
}GIF_FRAME;

//The gif table
//:)

typedef struct GIF_ANIM_STRUCT
{
GIF_FRAME *frames;
int frame_color;
int frame_width;
int frame_height;
int num_frames;
char local_pal;
int timepassed;
}GIF_ANIM;


//Contains lots of information, some probably not needed
typedef struct GIF_DATA_STRUCT
{
BITMAP *image;
//The Singiture
unsigned char id[6]; //Includes GIF + ver number
unsigned char buffer[255];
//Screen Descripter
unsigned char global_pal;
unsigned short int delay;
unsigned short int s_width;  //2 Bytes each
unsigned short int s_height;
unsigned char global_depth; //first 3 bits = pixel-1, 0, next 3 = bpp-1, next 1 = color map afterwards
unsigned char bpp;
unsigned char background; //next byte
unsigned char transparent;
unsigned char usetransparent;
unsigned char reserved; //Not reserved, for 89a use.
long int counter;
unsigned short int cc;
char interlaced;
unsigned char disposal;
//COLOUR TABLE HERE, how every big it is;
//rgb order
//Image descripter
//This  character  is defined as 0x2C hex or ',' Introduces image desc.
unsigned short int  ileft, itop, iwidth, iheight; //Are we even going to use this?
unsigned char depth; //0-3bytes, pixel-1,0,0,0,1 byte interlaced, 1 byte local pal.
//  character 0x3B hex or ';'  gif terminater, finished, end of gif. goodbye :p
unsigned char code_size;
unsigned char block_byte;

int liner;//This is for graphics optimization
int lineh; 
//This is for memory support
//And also for 
PACKFILE *fp_data;
unsigned char *mem_data;
}GIF_DATA;

//////////////////////////////////////User Functions
BITMAP *load_gif(const char *filename, RGB *pal);   //From File
BITMAP *load_gif_memory(void*, RGB *pal);           //From Memory
int save_gif(AL_CONST char *filename,BITMAP *image,AL_CONST RGB *pal);
int save_gif_anim(AL_CONST char *filename,GIF_ANIM *ga);
//For Animated Gifs
GIF_ANIM *load_gif_animated(const char *filename);
void free_gifa(GIF_ANIM *gif_a);
BITMAP *load_gif_animated_frame(const char *filename,RGB *pal,int frame);
int load_gif_animated_call(const char *filename, int(*callback)(GIF_FRAME *));
void *load_gif_animated_memory(void * fp); //From Memory
//Helper Functions for users
BITMAP * get_gifa_bitmapt(GIF_ANIM* ga,     int timepassed);
GIF_FRAME * get_gifa_framet(GIF_ANIM * ga,  int timepassed);
GIF_FRAME * get_gifa_framen(GIF_ANIM * ga,  int number);
BITMAP * get_gifa_bitmapn(GIF_ANIM * ga,    int number);
//For Packfiles
//Non Animated
void *load_gif_datafile(PACKFILE *fp, long size);
void destroy_gif_datafile(void *data);
//Animated
void *load_gif_anim_datafile(PACKFILE *fp, long size);
void destroy_gif_anim_datafile(void *data);
//Global Variables. Only 1.
extern int gif_a_settings; //Set this to ingore the background

////////////////////////////////////////////////
//////////////////////////////Private Functions
//Helper Functions
__inline void draw_lzw_pixel(GIF_DATA *gif, long counter,unsigned char color);
int gif_get_pixel(GIF_DATA *al_gif);
__inline int calc_interlaced_line(GIF_DATA *gif,long counter);
void create_gif_frame(GIF_DATA *al_gif,BITMAP *frame,BITMAP *prev,RGB *g_pal,int free_prev);
GIF_ANIM* create_gif_a(GIF_DATA *al_gif,LZW *table, RGB *g_pal,int frame_num);
int get_gif_lzw_code(LZW *table, GIF_DATA *gif);
int gif_write_code(LZW *table,GIF_DATA *al_gif, unsigned int code);
int gif_flush_code(LZW *table,GIF_DATA *al_gif);
unsigned char output_lzw_code(GIF_DATA *gif,LZW *table, int code);
int write_gif_header(PACKFILE *fp,int width, int height,AL_CONST RGB *pal);
int write_gif_frame(PACKFILE *fp,GIF_DATA *al_gif,AL_CONST RGB *pal);

//These are the main GIF loaders
int load_gif_header(GIF_DATA *al_gif,RGB *pal);
int load_gimage_header(GIF_DATA *al_gif,LZW*table,RGB *pal);
int decode_gif_image(GIF_DATA *al_gif,LZW *table, RGB *pal);


//Very Private Use, and specific, only used Internally
void gif_fread(void * data,int size,GIF_DATA * fp);
unsigned char gif_getc(GIF_DATA *fp);
//Memory See above Comment
void gmem_fread(void * data,int size,GIF_DATA * fp);
unsigned char gmem_getc(GIF_DATA * fp);
int get_gif_lzw_code(LZW *table, GIF_DATA *gif);
///////////////////////////////////////////////////////////////

#ifdef __cplusplus
   }
#endif

#endif
