/**********************************************/
/* Evert Glebbeek 2003                        */
/* eglebbk@dds.nl                             */
/**********************************************/
#include <allegro.h>
#include <string.h>
#include <stdio.h>

typedef struct SCORE_LIST {
   char *name;
   int score;
} SCORE_LIST;

static char *file = NULL;
static SCORE_LIST *scores = NULL;
static int ns = 0;

void init_highscore_list(int numscores, char *filename)
{
   char s[1024];
   int n;

   /* Free previous incarnation */
   for (n=0; n<ns; n++) {
      free(scores[n].name);
   }
   free(scores);
   free(file);
   
   /* Allocate one extra element */
   ns = numscores;
   scores = malloc((ns+1) * sizeof *scores);
   for (n=0; n<(ns+1); n++) {
      scores[n].name = NULL;
      scores[n].score = 0;
   }
   file = strdup(filename);
   
   /* Read highscore list */
   push_config_state();
   set_config_file(file);
   for (n=0; n<ns; n++) {
      sprintf (s, "name%d", n);
      scores[n].name = strdup(get_config_string("[highscore]", s, "---"));
      sprintf (s, "score%d", n);
      scores[n].score = get_config_int("[highscore]", s, 0);
   }
   pop_config_state();
}

/* qsort callback */
static int score_cmp(const void *p1, const void *p2)
{
   const SCORE_LIST *s1 = p1;
   const SCORE_LIST *s2 = p2;
   
   return s2->score - s1->score;
}

/* Returns TRUE if the score is a highscore */
int is_highscore(int score)
{
   return score>scores[ns-1].score;
}

/* Add a highscore to the list */
void add_highscore_list(char *name, int score)
{
   char s[1024];
   int n;

   ASSERT(scores);
   ASSERT(file);
   ASSERT(ns);
   
   if (score>scores[ns-1].score) {
      scores[ns].name = strdup(name);
      scores[ns].score = score;
      
      qsort(scores, ns+1, sizeof *scores, score_cmp);
      /* Clear final entry */
      free(scores[ns].name);
      scores[ns].name = NULL;
      scores[ns].score = 0;

      /* Write to file */
      push_config_state();
      set_config_file(file);
      for (n=0; n<ns && scores[n].score; n++) {
         sprintf (s, "name%d", n);
         set_config_string("[highscore]", s, scores[n].name);
         sprintf (s, "score%d", n);
         set_config_int("[highscore]", s, scores[n].score);
      }
      pop_config_state();
   }
}

/* Retrieve name */
char *get_highscore_name(int position)
{
   ASSERT(position<ns);
   ASSERT(position>=0);
   
   return scores[position].name;
}

/* Retrieve score */
int get_highscore_points(int position)
{
   ASSERT(position<ns);
   ASSERT(position>=0);
   
   return scores[position].score;
}

/* Print highscore list */
void show_highscore_list(BITMAP *bmp, const FONT *font, const int colour)
{
   int x1, x2, x3;
   int h;
   int y;
   int n;
   
   h = text_height(font);
   x1 = 128;
   x2 = x1+16;
   x3 = SCREEN_W - x1;
   y = (SCREEN_H-ns*h)/2;
   
   for (n=0; n<ns; n++) {
      text_mode(-1);
      textprintf_right(bmp, font, x1, y, colour, "%d", n+1);
      textprintf(bmp, font, x2, y, colour, "%s", scores[n].name);
      textprintf_right(bmp, font, x3, y, colour, "%d", scores[n].score);
      y+=h;
   }
}
