/**********************************************/
/* Evert Glebbeek 2003                        */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include <stdlib.h>
#include "droptab.h"
#include "genrand.h"
#include "monster.h"
#include "items.h"

/* The chance of each item being dropped is affected by the current level  */
/*  (devided by 5). Changes are in the range 0-255 (with 255 being 100%)   */
/* Note that they are stored cumulative: if bombs and arrows both have 50%,*/
/*  then arrows would have weight 128, bombs would have 127 (if an arrow   */
/*  doesn't drop, a bomb is certain to drop). What is stored is the chance */
/*  of that item dropping if none of those above it did                    */
typedef struct {
   int item;
   int chance[5];
} DROPTABLE;

static DROPTABLE item_droptable[] = {
   { ITEM_ARROW,        { 0x60, 0x60, 0x60, 0x60, 0x60 } },
   { ITEM_SARROW,       { 0x00, 0x00, 0x00, 0x00, 0x00 } },
   { ITEM_FARROW,       { 0x00, 0x00, 0x00, 0x00, 0x00 } },
   { ITEM_BOMB,         { 0x70, 0x70, 0x68, 0x68, 0x68 } },
   { ITEM_KEY,          { 0x00, 0x00, 0x00, 0x00, 0x00 } },
   { ITEM_POTION,       { 0x75, 0x78, 0x75, 0x75, 0x75 } },
   { ITEM_HEART,        { 0xB0, 0xB0, 0xA8, 0xA8, 0xA8 } },
   { ITEM_CANDLEHOLD,   { 0xB5, 0xB5, 0xB2, 0xB2, 0xB2 } },
   { ITEM_CHALICE,      { 0x00, 0x00, 0xB5, 0xB5, 0xB5 } },
   { ITEM_GEM,          { 0x00, 0xC0, 0xC0, 0xC0, 0xC0 } },
   { ITEM_POISON,       { 0x00, 0xD0, 0xD0, 0xD0, 0xD0 } },
   { ITEM_TRAP,         { 0x00, 0x00, 0xE0, 0xE0, 0xE0 } },
   { ITEM_NONE,         { 0x00, 0x00, 0x00, 0x00, 0x00 } }
};

/* Spawner monster drop frequency */
static DROPTABLE monster_droptable[] = {
   { MONSTER_BAT,        { 0x60, 0x40, 0x30, 0x20, 0x20 } },
   { MONSTER_GHOST,      { 0xC0, 0x90, 0x80, 0x50, 0x50 } },
   { MONSTER_ZOMBIE,     { 0xE0, 0xB0, 0xA0, 0x80, 0x60 } },
   { MONSTER_ARMEDZOMBIE,{ 0x00, 0xC0, 0xC0, 0xB0, 0xB0 } },
   { MONSTER_SKELETON,   { 0xF0, 0xD0, 0xC8, 0xC0, 0xB5 } },
   { MONSTER_VAMPIREBAT, { 0x00, 0xE7, 0xE7, 0xE0, 0xD0 } },
   { MONSTER_GHOUL,      { 0x00, 0xFF, 0xF0, 0xF0, 0xE0 } },
   { MONSTER_DAEMON,     { 0x00, 0x00, 0x00, 0x00, 0x00 } },
   { MONSTER_WIZARD,     { 0x00, 0x00, 0xFF, 0xFD, 0xF7 } },
   { MONSTER_GRIMREAPER, { 0x00, 0x00, 0x00, 0xFF, 0xFF } },
   { MONSTER_NONE,       { 0x00, 0x00, 0x00, 0x00, 0x00 } }
};

/* Drop a random item, based on the current level */
int drop_item(int level)
{
   int c;
   int l;
   int r;
   
   l = level/5;
   if (l>4)
      l = 4;
 
   r = genrandf()*256;  
   for (c=0; item_droptable[c].item!=ITEM_NONE; c++) {
      if (r<item_droptable[c].chance[l])
         return item_droptable[c].item;
   }
   return ITEM_NONE;
}

int spawn_monster(int level)
{
   int c;
   int l;
   int r;
   
   l = level/5;
   if (l>4)
      l = 4;
 
   r = genrandf()*256;  
   for (c=0; monster_droptable[c].item!=MONSTER_NONE; c++) {
      if (r<monster_droptable[c].chance[l])
         return monster_droptable[c].item;
   }
   return MONSTER_NONE;
}
