ifdef CPU
   CFLAGS += -mcpu=$(CPU)
endif

ifdef STATICLINK
   LIBS = `allegro-config --libs --static`
else
   ifdef SHAREDLINK
      LIBS = `allegro-config --libs --shared` -lm
   else
      LIBS = `allegro-config --libs` -lm
   endif
endif

ifdef OSTYPE
   OBJDIR = obj/$(OSTYPE)
   LIBDIR = lib/$(OSTYPE)
   EXEDIR = bin/$(OSTYPE)
else
   OBJDIR = obj/unix
   LIBDIR = lib/unix
   EXEDIR = bin/unix
endif

VERSION=`grep "define GAME_VERSION" Dark/include/dark.h | sed 's/\#define GAME_VERSION[ ]*\"//'| sed 's/\"//'`
BINARCH = dark-$(VERSION)-bin-`uname -m`
SRCARCH = dark-$(VERSION)-src
DATARCH = dark-$(VERSION)-dat

CFLAGS += -pipe
