#ifndef UNITPROG_H
#define UNITPROG_H

#include "unit.h"
typedef int (*CPOPCODE)(CHARDATA *unit, int *loop);

extern SCRIPT_STACK *duplicate_commands(SCRIPT_STACK *p);
extern SCRIPT_STACK *match_prog_flags(SCRIPT_STACK *p, int flags);

extern void push_command (CHARDATA *c, char *minip, int flag);
extern void pass_script_argument(CHARDATA *c, int arg);
extern void insert_command (CHARDATA *s, char *minip, int flag, int del);
extern void release_prog_head (CHARDATA *c);
extern void rmv_command_tail (CHARDATA *c);
extern void remove_commands (CHARDATA *c);
extern void loop_command (CHARDATA *c);
extern void stop_all_scripts (void);

extern int get_queuecount(CHARDATA *c);
extern int push_queue(CHARDATA *c, TARGET target, int command_id);
extern void pop_queue(CHARDATA *c);
extern int clear_queue_head(CHARDATA *c);

extern void script_cp_init(void);
extern void register_opcode (const int opcode, CPOPCODE func);
extern int script_exec(CHARDATA *c);

#endif
