#ifndef SCRIPT_H
#define SCRIPT_H

/* Script flags. Some of these are set by external events */
#define SCRIPT_SAVE     1  /* Do not remove from stack when completed */
#define SCRIPT_ZF       2  /* Zero flag */
#define SCRIPT_SF       4  /* Sign flag */
#define SCRIPT_LOOP     8  /* Loop flag */
#define SCRIPT_CANCEL  16  /* Script cancel flag */
#define SCRIPT_SIGNAL  32  /* Script signal flag */
#define SCRIPT_FLOAT   64  /* Override: treat numbers as floats */

#define SCRIPT_STKSIZE  8  /* Size of script stack */

/* General opcode description, for the parser */
typedef struct {
   char *mnemonic;
   unsigned char bytecode;
} PARSE_OPCODE;

/* Recognized symbolic parameters and their translation to byte-code parameters */
typedef struct {
   char *parse_name;
   int num_value;
   int is_a_number;
} PARSE_IDENTIFIER;

/* Actual script structure */
typedef struct SCRIPT {
   char *script_name;      /* The script name                  */
   unsigned char *script;  /* The actual script bytecode data  */
   int argv[3];            /* Argument list                    */
   int argc;               /* Argument count                   */
   int flags;              /* Script flags                     */
   int ss[SCRIPT_STKSIZE]; /* Script stack                     */
   int ip;                 /* Instruction pointer              */
   int sp;                 /* Stack pointer                    */
   int wait;               /* Wait counter                     */
} SCRIPT;

extern void unload_scripts(void);
extern int load_scripts(char *filename);
extern SCRIPT *find_script(char *name);
extern void pass_one(void);
extern void pass_two(void);
#endif
