#ifndef GFX_H
#define GFX_H

/* (Dirty) rectangle data structure */
typedef struct DRECT {
	int x, y, w, h;
} DRECT;

/* gfx global variables */
extern int black;
extern int grey;
extern int white;
extern int red;
extern int yellow;
extern int blue;
extern int green;
extern int bright_red;
extern int bright_blue;
extern int darkgreen;

/* Function templates */
extern int (*makecolour)(int r, int g, int b);

/* Graphics functions */
extern BITMAP *get_commandmap_bmp(void);
extern BITMAP *get_interface_bmp(void);
extern void set_commandmap (const int x, const int y, const int w, const int h);
extern void set_interface (const int x, const int y, const int w, const int h);

extern int set_graphics(void);
extern BITMAP *create_optimized_mask_bitmap(const int w, const int h);
extern BITMAP *create_optimized_bitmap(const int w, const int h);
extern BITMAP *get_screen_bmp(void);
extern BITMAP *get_monitor_bmp(void);
extern BITMAP *outline_bitmap (BITMAP *bmp, const int colour);
extern inline int get_mcptr_hotx(void);
extern inline int get_mcptr_hoty(void);
extern inline int get_mcptr_w(void);
extern inline int get_mcptr_h(void);
extern inline int get_commandmap_width(void);
extern inline int get_commandmap_height(void);
extern inline int get_commandmap_x(void);
extern inline int get_commandmap_y(void);

extern void screenshot(void);

extern int get_fps(void);
extern void install_fps_counter(void);
extern void uninstall_fps_counter(void);

extern void push_render_job (BITMAP *bmp, int x, int y, int w, int h, int c1,int c2,int c3,int c4);
extern void do_render_job (void);

extern void prepare_screen(void);
extern void prepare_screen_update(void);
extern void screen_update_done(void);

extern void mark_rect(int x, int y, int w, int h);
extern void store_rect(int x, int y, int w, int h);
extern void mark_commandmap(void);
extern void mark_interface(void);

#endif
