/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------------\
|                                         3do.cpp                                    |
|  ce fichier contient les structures, classes et fonctions nécessaires à la lecture |
| des fichiers 3do de total annihilation qui sont les fichiers contenant les modèles |
| 3d des objets du jeu.                                                              |
|                                                                                    |
\-----------------------------------------------------------------------------------*/

#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include "matrix.h"
#include "ta3dbase.h"
#include "3do.h"

TEXTURE_MANAGER	texture_manager;
MODEL_MANAGER	model_manager;

	int TEXTURE_MANAGER::load_gaf(byte *data)
	{
		int nb_entry=get_gaf_nb_entry(data);
		int n_nbtex=nbtex+nb_entry;
		GLuint *n_gl=(GLuint*) malloc(sizeof(GLuint)*n_nbtex);
		char **n_name=(char**) malloc(sizeof(char*)*n_nbtex);
		BITMAP **n_bmp=(BITMAP**) malloc(sizeof(BITMAP*)*n_nbtex);
		int i;
		for(i=0;i<nbtex;i++) {
			n_gl[i]=gltex[i];
			n_name[i]=name[i];
			n_bmp[i]=bmptex[i];
			}
		free(gltex);
		free(name);
		name=n_name;
		gltex=n_gl;
		bmptex=n_bmp;
		for(i=0;i<nb_entry;i++) {
			int nb_img=get_gaf_nb_img(data,i);
			BITMAP *img=read_gaf_img(data,i,0,NULL,NULL,false);
			BITMAP *tmp=create_bitmap(img->w,img->h);
			blit(img,tmp,0,0,0,0,img->w,img->h);
			destroy_bitmap(img);
			img=tmp;
			name[nbtex+i]=get_gaf_entry_name(data,i);
			if(g_useTextureCompression)
				allegro_gl_set_texture_format(GL_COMPRESSED_RGB_ARB);
			else
				allegro_gl_set_texture_format(GL_RGB5);
			gltex[nbtex+i]=allegro_gl_make_texture(img);
			glBindTexture(GL_TEXTURE_2D,gltex[nbtex+i]);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
			bmptex[nbtex+i]=img;
			}
		nbtex+=nb_entry;
		return 0;
	}

	void SCRIPT_DATA::move(float dt)
	{
		for(int i=0;i<3;i++)
			for(int e=0;e<nb_piece;e++) {
				float a=axe[i][e].move_distance;
				if(a!=0.0f) {
					float c=axe[i][e].move_speed*dt;
					axe[i][e].move_distance-=c;
					axe[i][e].pos+=c;
					if((a>0.0f && axe[i][e].move_distance<0.0f) || (a<0.0f && axe[i][e].move_distance>0.0f)) {
						axe[i][e].pos+=axe[i][e].move_distance;
						axe[i][e].move_distance=0.0f;
						}
					}
				while(axe[i][e].angle>180.0f)	axe[i][e].angle-=360.0f;		// Maintient l'angle dans les limites
				while(axe[i][e].angle<-180.0f)	axe[i][e].angle+=360.0f;
				a=axe[i][e].rot_angle;
				if((axe[i][e].rot_speed!=0.0f || axe[i][e].rot_accel!=0.0f) && ((a!=0.0f && axe[i][e].rot_limit) || !axe[i][e].rot_limit)) {
					float b=axe[i][e].rot_speed;
					if(b<-7200.0f)
						b=axe[i][e].rot_speed=-7200.0f;
					if(b>7200.0f)
						b=axe[i][e].rot_speed=7200.0f;
					axe[i][e].rot_speed+=axe[i][e].rot_accel*dt;
					if(axe[i][e].rot_speed_limit)
						if((b<0.0f && axe[i][e].rot_speed-axe[i][e].rot_target_speed>0.0f) || (b>0.0f && axe[i][e].rot_speed-axe[i][e].rot_target_speed<0.0f)) {
							axe[i][e].rot_accel=0.0f;
							axe[i][e].rot_speed=axe[i][e].rot_target_speed;
							axe[i][e].rot_speed_limit=false;
							}
					float c=axe[i][e].rot_speed*dt;
					axe[i][e].angle+=c;
					if(axe[i][e].rot_limit) {
						axe[i][e].rot_angle-=c;
						if((a>0.0f && axe[i][e].rot_angle<0.0f) || (a<0.0f && axe[i][e].rot_angle>0.0f)) {
							axe[i][e].angle+=axe[i][e].rot_angle;
							axe[i][e].rot_angle=0.0f;
							}
						}
					}
				}
	}

	int OBJECT::load_obj(byte *data,int offset,int dec)
	{
		destroy();					// Au cas où l'objet ne serait pas vierge

		tagObject header;				// Lit l'en-tête
		header.VersionSignature=*((int*)(data+offset));
		header.NumberOfVertexes=*((int*)(data+offset+4));
		header.NumberOfPrimitives=*((int*)(data+offset+8));
		header.OffsetToselectionPrimitive=*((int*)(data+offset+12));
		header.XFromParent=*((int*)(data+offset+16));
		header.YFromParent=*((int*)(data+offset+20));
		header.ZFromParent=*((int*)(data+offset+24));
		header.OffsetToObjectName=*((int*)(data+offset+28));
		header.Always_0=*((int*)(data+offset+32));
		header.OffsetToVertexArray=*((int*)(data+offset+36));
		header.OffsetToPrimitiveArray=*((int*)(data+offset+40));
		header.OffsetToSiblingObject=*((int*)(data+offset+44));
		header.OffsetToChildObject=*((int*)(data+offset+48));

		nb_vtx=header.NumberOfVertexes;
		nb_prim=header.NumberOfPrimitives;
		name=strdup((char*)(data+header.OffsetToObjectName));
		int i;
#ifdef DEBUG_MODE
/*		for(i=0;i<dec;i++)
			printf("  ");
		printf("%s",name);
		for(i=0;i<20-2*dec-strlen(name);i++)
			printf(" ");
		printf("-> nb_vtx=%d | nb_prim=%d\n",nb_vtx,nb_prim);*/
#endif
		if(header.OffsetToChildObject) {					// Charge récursivement les différents objets du modèle
			child=(OBJECT*) malloc(sizeof(OBJECT));
			child->init();
			child->load_obj(data,header.OffsetToChildObject,dec+1);
			}
		if(header.OffsetToSiblingObject) {					// Charge récursivement les différents objets du modèle
			next=(OBJECT*) malloc(sizeof(OBJECT));
			next->init();
			next->load_obj(data,header.OffsetToSiblingObject,dec);
			}
		points=(POINTF*) malloc(sizeof(POINTF)*nb_vtx);		// Alloue la mémoire nécessaire pour stocker les points
		int f_pos;
		float div=1.0f/65536.0f;
		pos_from_parent.x=header.XFromParent*div;
		pos_from_parent.y=header.YFromParent*div;
		pos_from_parent.z=-header.ZFromParent*div;
		f_pos=header.OffsetToVertexArray;
		for(i=0;i<nb_vtx;i++) {				// Lit le tableau de points stocké dans le fichier
			tagVertex vertex;
			vertex.x=*((int*)(data+f_pos));		f_pos+=4;
			vertex.y=*((int*)(data+f_pos));		f_pos+=4;
			vertex.z=*((int*)(data+f_pos));		f_pos+=4;
			points[i].x=vertex.x*div;
			points[i].y=vertex.y*div;
			points[i].z=-vertex.z*div;
			}
		f_pos=header.OffsetToPrimitiveArray;
		int n_index=0;
		selprim=header.OffsetToselectionPrimitive;
		for(i=0;i<nb_prim;i++) {					// Compte le nombre de primitive de chaque sorte
			tagPrimitive primitive;
			primitive.ColorIndex=*((int*)(data+f_pos));						f_pos+=4;
			primitive.NumberOfVertexIndexes=*((int*)(data+f_pos));			f_pos+=4;
			primitive.Always_0=*((int*)(data+f_pos));						f_pos+=4;
			primitive.OffsetToVertexIndexArray=*((int*)(data+f_pos));		f_pos+=4;
			primitive.OffsetToTextureName=*((int*)(data+f_pos));			f_pos+=4;
			primitive.Unknown_1=*((int*)(data+f_pos));						f_pos+=4;
			primitive.Unknown_2=*((int*)(data+f_pos));						f_pos+=4;
			primitive.Unknown_3=*((int*)(data+f_pos));						f_pos+=4;

			switch(primitive.NumberOfVertexIndexes)
			{
			case 1:		nb_p_index++;	break;
			case 2:		nb_l_index++;	break;
			default:
				n_index+=primitive.NumberOfVertexIndexes;
				nb_t_index++;
			};
			}
#ifdef DEBUG_MODE
//		printf("(%d,%d,%d)\n",nb_p_index,nb_l_index,nb_t_index);
#endif

		if(nb_p_index>0)				// Alloue la mémoire nécessaire pour stocker les primitives
			p_index=(GLuint*) malloc(sizeof(GLuint)*nb_p_index);
		if(nb_l_index>0)
			l_index=(GLuint*) malloc(sizeof(GLuint)*nb_l_index*2);
		if(nb_t_index>0) {
			tex=(GLuint*) malloc(sizeof(GLuint)*nb_t_index);
			usetex=(byte*) malloc(sizeof(byte)*nb_t_index);
			nb_index=(short*) malloc(sizeof(short)*nb_t_index);
			t_index=(GLuint*) malloc(sizeof(GLuint)*n_index);
			}

		f_pos=header.OffsetToPrimitiveArray;
		int pos_p=0,pos_l=0,pos_t=0,cur=0;
		int nb_diff_tex=0;
		int index_tex[nb_prim];
		for(i=0;i<nb_prim;i++) {					// Compte le nombre de primitive de chaque sorte
			tagPrimitive primitive;
			primitive.ColorIndex=*((int*)(data+f_pos));						f_pos+=4;
			primitive.NumberOfVertexIndexes=*((int*)(data+f_pos));			f_pos+=4;
			primitive.Always_0=*((int*)(data+f_pos));						f_pos+=4;
			primitive.OffsetToVertexIndexArray=*((int*)(data+f_pos));		f_pos+=4;
			primitive.OffsetToTextureName=*((int*)(data+f_pos));			f_pos+=4;
			primitive.Unknown_1=*((int*)(data+f_pos));						f_pos+=4;
			primitive.Unknown_2=*((int*)(data+f_pos));						f_pos+=4;
			primitive.Unknown_3=*((int*)(data+f_pos));						f_pos+=4;

			switch(primitive.NumberOfVertexIndexes)
			{
			case 1:
				p_index[pos_p++]=*((short*)(data+primitive.OffsetToVertexIndexArray));
				break;
			case 2:
				l_index[pos_l++]=*((short*)(data+primitive.OffsetToVertexIndexArray));
				l_index[pos_l++]=*((short*)(data+primitive.OffsetToVertexIndexArray+2));
				break;
			default:
				nb_index[cur]=primitive.NumberOfVertexIndexes;
				tex[cur]=texture_manager.get_texture_index((char*)(data+primitive.OffsetToTextureName));
				usetex[cur]=1;
				if(texture_manager.get_texture_index((char*)(data+primitive.OffsetToTextureName))==-1)
					usetex[cur]=0;
				else {														// Code pour la création d'une texture propre à chaque modèle
					bool al_in=false;
					int indx=texture_manager.get_texture_index((char*)(data+primitive.OffsetToTextureName));
					for(int e=0;e<nb_diff_tex;e++)
						if(index_tex[e]==indx) {
							al_in=true;
							break;
							}
					if(!al_in)
						index_tex[nb_diff_tex++]=indx;
				}
				for(int e=0;e<nb_index[cur];e++)
					t_index[pos_t++]=*((short*)(data+primitive.OffsetToVertexIndexArray+e*2));
				cur++;
			};
			}
/*------------------------------Création de la texture unique pour l'unité--------------*/
		int px[nb_diff_tex],py[nb_diff_tex];			// Pour placer les différentes mini-textures sur une grande texture
		int mx=0,my=0;
		for(i=0;i<nb_diff_tex;i++) {
			int dx=texture_manager.bmptex[index_tex[i]]->w,dy=texture_manager.bmptex[index_tex[i]]->h;
			px[i]=py[i]=0;
			if(i!=0)
				for(int e=0;e<i;e++) {
					int fx=texture_manager.bmptex[index_tex[e]]->w,fy=texture_manager.bmptex[index_tex[e]]->h;
					bool found[3];
					found[0]=found[1]=found[2]=true;
					int j;

					px[i]=px[e]+fx;		py[i]=py[e];
					for(j=0;j<i;j++) {
						int gx=texture_manager.bmptex[index_tex[j]]->w,gy=texture_manager.bmptex[index_tex[j]]->h;
						if(coupe(px[i],py[i],dx,dy,px[j],py[j],gx,gy)) {
							found[0]=false;
							break;
							}
						}

					px[i]=px[e];		py[i]=py[e]+fy;
					for(j=0;j<i;j++) {
						int gx=texture_manager.bmptex[index_tex[j]]->w,gy=texture_manager.bmptex[index_tex[j]]->h;
						if(coupe(px[i],py[i],dx,dy,px[j],py[j],gx,gy)) {
							found[2]=false;
							break;
							}
						}
					px[i]=px[e]+fx;		py[i]=0;
					for(j=0;j<i;j++) {
						int gx=texture_manager.bmptex[index_tex[j]]->w,gy=texture_manager.bmptex[index_tex[j]]->h;
						if(coupe(px[i],py[i],dx,dy,px[j],py[j],gx,gy)) {
							found[1]=false;
							break;
							}
						}
					bool deborde=false;
					bool found_one=false;
					int deb=0;
					if(found[1]) {
						px[i]=px[e]+fx;
						py[i]=0;
						deborde=false;
						if(px[i]+dx>mx || py[i]+dy>my) deborde=true;
						deb=max(mx,px[i]+dx)*max(py[i]+dy,my)-mx*my;
						found_one=true;
						}
					if(found[0] && (!found_one || deborde)) {
						px[i]=px[e]+fx;
						py[i]=py[e];
						deborde=false;
						if(px[i]+dx>mx || py[i]+dy>my) deborde=true;
						deb=max(mx,px[i]+dx)*max(py[i]+dy,my)-mx*my;
						found_one=true;
						}
					if(found[2] && deborde) {
						int ax=px[i],ay=py[i];
						px[i]=px[e];
						py[i]=py[e]+fy;
						deborde=false;
						if(px[i]+dx>mx || py[i]+dy>my) deborde=true;
						int deb2=max(mx,px[i]+dx)*max(py[i]+dy,my)-mx*my;
						if(found_one && deb<deb2) {
							px[i]=ax;	py[i]=ay;
							}
						else
							found_one=true;
						}
					if(found_one)			// On a trouvé une position qui convient
						break;
					}
			if(px[i]+dx>mx) mx=px[i]+dx;
			if(py[i]+dy>my) my=py[i]+dy;
			}
		BITMAP *bmp=create_bitmap(mx,my);
		clear(bmp);
		for(i=0;i<nb_diff_tex;i++)
			blit(texture_manager.bmptex[index_tex[i]],bmp,0,0,px[i],py[i],texture_manager.bmptex[index_tex[i]]->w,texture_manager.bmptex[index_tex[i]]->h);
		if(g_useTextureCompression)
			allegro_gl_set_texture_format(GL_COMPRESSED_RGB_ARB);
		else
			allegro_gl_set_texture_format(GL_RGB5);
		gltex=allegro_gl_make_texture(bmp);	dtex=true;
		glBindTexture(GL_TEXTURE_2D,gltex);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
		destroy_bitmap(bmp);
		int nb_total_point=0;
		for(i=0;i<nb_t_index;i++)
			nb_total_point+=nb_index[i];
		POINTF *p=(POINTF*) malloc(sizeof(POINTF)*nb_total_point);
		for(i=0;i<nb_total_point;i++) {
			p[i]=points[t_index[i]];
			t_index[i]=i;
			}
		free(points);
		points=p;
		nb_vtx=nb_total_point;

		int nb_triangle=0;
		for(i=0;i<nb_t_index;i++)
			if(i!=selprim)
				nb_triangle+=nb_index[i]-2;
		GLuint *index=(GLuint*) malloc(sizeof(GLuint)*nb_triangle*3);
		tcoord=(float*) malloc(sizeof(float)*nb_vtx*2);
		cur=0;
		int curt=0;
		pos_t=0;
		for(i=0;i<nb_t_index;i++)
			for(int e=0;e<nb_index[i];e++) {
				if(i==selprim) {
					if(e==0) {
						sel[0]=t_index[cur];
						sel[1]=t_index[cur+1];
						sel[2]=t_index[cur+2];
						sel[3]=t_index[cur+3];
						cur+=nb_index[i];
						}
					continue;
					}
				if(e<3)
					index[pos_t++]=t_index[cur];
				else {
					index[pos_t]=index[pos_t-3];	pos_t++;
					index[pos_t]=index[pos_t-2];	pos_t++;
					index[pos_t++]=t_index[cur];
					}
				tcoord[curt]=0.0f;
				tcoord[curt+1]=0.0f;
				if(tex[i]!=-1) {
					switch(e&3)
					{
					case 0:						break;
					case 1:
						tcoord[curt]+=((float)texture_manager.bmptex[tex[i]]->w-1)/(mx-1);
						break;
					case 2:
						tcoord[curt]+=((float)texture_manager.bmptex[tex[i]]->w-1)/(mx-1);
						tcoord[curt+1]+=((float)texture_manager.bmptex[tex[i]]->h-1)/(my-1);
						break;
					case 3:
						tcoord[curt+1]+=((float)texture_manager.bmptex[tex[i]]->h-1)/(my-1);
						break;
					};
					int indx=0;
					for(int f=0;f<nb_diff_tex;f++)
						if(tex[i]==index_tex[f]) {
							indx=f;
							break;
							}
					tcoord[curt]+=(float)px[indx]/(mx-1);
					tcoord[curt+1]+=(float)py[indx]/(my-1);
					}
				cur++;
				curt+=2;
				}
		for(cur=0;cur<pos_t;cur+=3) {			// Petite inversion pour avoir un affichage correct
			GLuint t=index[cur+1];
			index[cur+1]=index[cur+2];
			index[cur+2]=t;
			}
		nb_t_index=nb_triangle*3;
		free(t_index);
		t_index=index;
/*--------------------------------------------------------------------------------------*/

		if(nb_t_index>0) {			// Calcule les normales pour l'éclairage
			N=(VECTOR*) malloc(sizeof(VECTOR)*nb_vtx);
			for(i=0;i<nb_vtx;i++)
				N[i].x=N[i].z=N[i].y=0.0f;
			for(i=0;i<nb_t_index;i+=3) {
				VECTOR AB,AC,Normal;
				AB=points[t_index[i]]>>points[t_index[i+1]];
				AC=points[t_index[i]]>>points[t_index[i+2]];
				Normal=AB*AC;	Normal.Unit();
				for(int e=0;e<3;e++)
					N[t_index[i+e]]=N[t_index[i+e]]+Normal;
				}
			for(i=0;i<nb_vtx;i++)
				N[i].Unit();
			}
		return 0;
	}

	bool OBJECT::draw(SCRIPT_DATA *data_s,bool sel_primitive,bool alset,VECTOR *pos,bool notex)
	{
		glPushMatrix();
		glTranslatef(pos_from_parent.x,pos_from_parent.y,pos_from_parent.z);
		bool hide=false;
		if(script_index>=0 && data_s) {
			glTranslatef(data_s->axe[0][script_index].pos, data_s->axe[1][script_index].pos, data_s->axe[2][script_index].pos);
			glRotatef(data_s->axe[0][script_index].angle, 1.0f, 0.0f, 0.0f);
			glRotatef(data_s->axe[1][script_index].angle, 0.0f, 1.0f, 0.0f);
			glRotatef(data_s->axe[2][script_index].angle, 0.0f, 0.0f, 1.0f);
			hide=data_s->flag[script_index]&FLAG_HIDE;
			data_s->pos[script_index]=*pos;
			}
			if(nb_t_index>0 && !hide) {
				if(!alset) {
					glEnableClientState(GL_VERTEX_ARRAY);		// Les sommets
					glEnableClientState(GL_NORMAL_ARRAY);
					if(notex)
						glDisableClientState(GL_TEXTURE_COORD_ARRAY);
					else
						glEnableClientState(GL_TEXTURE_COORD_ARRAY);
					glEnable(GL_LIGHTING);
					if(notex)
						glDisable(GL_TEXTURE_2D);
					else
						glEnable(GL_TEXTURE_2D);
					alset=true;
					}
				glVertexPointer( 3, GL_FLOAT, 0, points);
				glNormalPointer( GL_FLOAT, 0, N);
				if(!notex) {
					glBindTexture(GL_TEXTURE_2D,gltex);
					glTexCoordPointer(2, GL_FLOAT, 0, tcoord);
					}
				glDrawElements(GL_TRIANGLES, nb_t_index,GL_UNSIGNED_INT,t_index);		// dessine le tout
				if(sel_primitive && selprim>=0) {
					glDisableClientState(GL_TEXTURE_COORD_ARRAY);
					glDisableClientState(GL_NORMAL_ARRAY);
					glDisable(GL_LIGHTING);
					glDisable(GL_TEXTURE_2D);
					glDisable(GL_CULL_FACE);
					glPolygonMode (GL_FRONT_AND_BACK, GL_LINE);
					glColor3f(1.0f,1.0f,0.0f);
					glDrawElements(GL_QUADS, 4,GL_UNSIGNED_INT,sel);		// dessine la primitive de sélection
					if(notex) {
						float var=fabs(1.0f-(Atimer%MSEC_TO_TIMER(1000))/(float)MSEC_TO_TIMER(500));
						glColor3f(0.0f,var,0.0f);
						}
					else
						glColor3f(1.0f,1.0f,1.0f);
					glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);
					glEnable(GL_CULL_FACE);
					alset=false;
					}
				}
		if(child) {
			*pos=*pos+pos_from_parent;
			glPushMatrix();
			alset=child->draw(data_s,sel_primitive,alset,pos,notex);
			glPopMatrix();
			*pos=*pos-pos_from_parent;
			}
		if(next) {
			glPopMatrix();
			glPushMatrix();
			alset=next->draw(data_s,sel_primitive,alset,pos,notex);
			glPopMatrix();
			}
		else
			glPopMatrix();
		return alset;
	}

	bool OBJECT::draw_shadow(VECTOR Dir,SCRIPT_DATA *data_s,bool alset)
	{
		glPushMatrix();
		glTranslatef(pos_from_parent.x,pos_from_parent.y,pos_from_parent.z);
		bool hide=false;
		VECTOR ODir=Dir;
		if(script_index>=0 && data_s) {
			glTranslatef(data_s->axe[0][script_index].pos, data_s->axe[1][script_index].pos, data_s->axe[2][script_index].pos);
			glRotatef(data_s->axe[0][script_index].angle, 1.0f, 0.0f, 0.0f);
			glRotatef(data_s->axe[1][script_index].angle, 0.0f, 1.0f, 0.0f);
			glRotatef(data_s->axe[2][script_index].angle, 0.0f, 0.0f, 1.0f);
			Dir=Dir*RotateZ(-data_s->axe[2][script_index].angle*DEG2RAD)*RotateY(-data_s->axe[1][script_index].angle*DEG2RAD)*RotateX(-data_s->axe[0][script_index].angle*DEG2RAD);
			hide=data_s->flag[script_index]&FLAG_HIDE;
			}
			if(nb_t_index>0 && !hide) {
				if(!alset) {
					glDisable(GL_LIGHTING);
					glDisable(GL_TEXTURE_2D);
					alset=true;
					}
				glBegin(GL_QUADS);
				POINTF AP,BP,CP;
				POINTF A,B,C;
				int posA=0,posB=0,posC=0;
/*-----------------Code expérimental--------------------------------------*/
				for(int i=0;i<nb_t_index;i+=3) {
					A=points[t_index[i]];
					B=points[t_index[i+1]];
					C=points[t_index[i+2]];
					VECTOR N=(A>>B)*(A>>C);
					if((N%Dir)>=0.0f) continue;
					AP=A+Dir;				// Calcules de projection
					BP=B+Dir;
					CP=C+Dir;

					N=(A>>B)*(A>>BP);
					glNormal3f(N.x,N.y,N.z);
					glVertex3f(A.x,A.y,A.z);	glVertex3f(B.x,B.y,B.z);		// Dessine les bords du volume d'ombre
					glVertex3f(BP.x,BP.y,BP.z);	glVertex3f(AP.x,AP.y,AP.z);

					N=(B>>C)*(B>>CP);
					glNormal3f(N.x,N.y,N.z);
					glVertex3f(B.x,B.y,B.z);	glVertex3f(C.x,C.y,C.z);
					glVertex3f(CP.x,CP.y,CP.z);	glVertex3f(BP.x,BP.y,BP.z);

					N=(C>>A)*(C>>AP);
					glNormal3f(N.x,N.y,N.z);
					glVertex3f(C.x,C.y,C.z);	glVertex3f(A.x,A.y,A.z);
					glVertex3f(AP.x,AP.y,AP.z);	glVertex3f(CP.x,CP.y,CP.z);
					}
				glEnd();
				}
		if(child) {
			glPushMatrix();
			alset=child->draw_shadow(Dir,data_s,alset);
			glPopMatrix();
			}
		if(next) {
			glPopMatrix();
			glPushMatrix();
			alset=next->draw_shadow(ODir,data_s,alset);
			glPopMatrix();
			}
		else
			glPopMatrix();
		return alset;
	}
