/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*----------------------------------------------------------------------\
|                               console.cpp                             |
|      contient les classes nécessaires à la gestion d'une console dans |
| programme utilisant Allegro avec ou sans AllegroGL. La console        |
| dispose de sa propre procédure d'entrée et d'affichage mais celle-ci  |
| nécessite d'être appellée manuellement pour éviter les problèmes      |
| découlant d'un appel automatique par un timer.                        |
\----------------------------------------------------------------------*/

#include <allegro.h>
#include <alleggl.h>
#include "console.h"

CONSOLE *Console;		// Console par défaut

		// Affiche les donnÃ©es systÃšme dans une console
void print_system_data(CONSOLE *console)
{
	char *str=new char[1000];

	memcpy(str,"Allegro ",9);			// Version d'allegro
	strcat(str,ALLEGRO_VERSION_STR);
	strcat(str," (");
	strcat(str,ALLEGRO_DATE_STR);
	strcat(str,")");
	console->AddEntry(str);

#ifdef AGL_VERSION						// Version d'allegroGL
	memcpy(str,"Utilise AllegroGL ",19);
	strcat(str,AGL_VERSION_STR);
	console->AddEntry(str);
#else
	console->AddEntry("N'utilise pas AllegroGL");
#endif

	switch(os_type)					// SystÃšme d'exploitation
	{
	case OSTYPE_WIN3:		console->AddEntry("OS : Windows 3.1");	break;
	case OSTYPE_WIN95:		console->AddEntry("OS : Windows 95");	break;
	case OSTYPE_WIN98:		console->AddEntry("OS : Windows 98");	break;
	case OSTYPE_WINME:		console->AddEntry("OS : Windows ME");	break;
	case OSTYPE_WINNT:		console->AddEntry("OS : Windows NT");	break;
	case OSTYPE_WIN2000:	console->AddEntry("OS : Windows 2000");	break;
	case OSTYPE_WINXP:		console->AddEntry("OS : Windows XP");	break;
	case OSTYPE_LINUX:		console->AddEntry("OS : Linux");		break;
	case OSTYPE_FREEBSD:	console->AddEntry("OS : FreeBSD");		break;
	case OSTYPE_NETBSD:		console->AddEntry("OS : NetBSD");		break;
	case OSTYPE_UNIX:		console->AddEntry("OS : UNIX");			break;
	};

	memcpy(str,"Processeur: ix86 ",18);		// Processeur
	if(cpu_family<10 && cpu_family!=0)
		str[13]='0'+cpu_family;
	else
		memcpy(str,"Processeur: x86_64 ",20);		// Processeur
	strcat(str,cpu_vendor);
	strcat(str," ");
	if(cpu_capabilities&CPU_ID)			strcat(str,"-cpuid");
	if(cpu_capabilities&CPU_FPU)		strcat(str,"-x87 FPU");
	if(cpu_capabilities&CPU_MMX)		strcat(str,"-MMX");
	if(cpu_capabilities&CPU_MMXPLUS)	strcat(str,"-MMX+");
	if(cpu_capabilities&CPU_SSE)		strcat(str,"-SSE");
	if(cpu_capabilities&CPU_SSE2)		strcat(str,"-SSE2");
	if(cpu_capabilities&CPU_3DNOW)		strcat(str,"-3DNow!");
	if(cpu_capabilities&CPU_ENH3DNOW)	strcat(str,"-Enhanced 3DNow!");
	if(cpu_capabilities&CPU_CMOV)		strcat(str,"-cmov");
	console->AddEntry(str);
	delete str;
}
