/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------------\
|                                       weapons.h                                    |
|  Ce fichier contient les structures, classes et fonctions nécessaires à la lecture |
| des fichiers tdf du jeu totalannihilation concernant les armes utilisées par les   |
| unités du jeu.                                                                     |
|                                                                                    |
\-----------------------------------------------------------------------------------*/

#ifndef __WEAPON_CLASSES
#define __WEAPON_CLASSES

struct WEAPON
{
	int		weapon_id;			// Numéro identifiant l'arme
	char	*internal_name;		// Nom interne de l'arme
	char	*name;				// Nom de l'arme
	int		rendertype;
	bool	ballistic;
	bool	turret;
	int		range;				// portée
	float	reloadtime;			// temps de rechargement
	int		weaponvelocity;
	int		areaofeffect;		// zone d'effet
	bool	startsmoke;
	int		damage;				// Dégats causés par l'arme
	int		firestarter;
	int		accuracy;
	int		aimrate;
	int		tolerance;
	int		holdtime;
	int		energypershot;
	int		metalpershot;
	int		minbarrelangle;
	bool	unitsonly;
	float	edgeeffectiveness;
	bool	lineofsight;
	bool	soundtrigger;
	int		color[2];
	float	burstrate;
	float	duration;
	bool	beamweapon;
	int		startvelocity;			// Pour les missiles
	int		weapontimer;				// Pour les missiles
	int		weaponacceleration;		// Pour les missiles
	int		turnrate;				// Pour les missiles
	MODEL	*model;					// Modèle 3D
	float	smokedelay;
	bool	guidance;				// Guidage
	bool	tracks;
	bool	selfprop;
	bool	smoketrail;				// Laisse de la fumée en passant
	bool	noautorange;
	int		flighttime;
	bool	vlaunch;
	bool	stockpile;
	bool	targetable;				// On peut viser
	bool	commandfire;				// ne tire pas seul
	bool	cruise;
	bool	propeller;
	bool	twophase;
	int		shakemagnitude;
	float	shakeduration;
};

#endif
