#include "../engine/GLRectangle.h"
#include "../engine/TextRenderer.h"
#include "../misc/TextHandler.h"
#include "../misc/KeyReader.h"
#include "../sound/SoundSystem.h"

#include "MenuWindow.h"

/***********************************************/

MenuWindow::MenuWindow(std::string text, const std::string* options, int optionCount, int def, int width)
	: IWindow(text, width), highlighted(def), selected(-1), optionCount(optionCount), options(options)
{
	if (optionCount > 0)
		height += 8 + 20 * optionCount;
	
	if (y + height > 470.0)
		y = 470.0 - height;
}

/***********************************************/

void MenuWindow::step(double)
{
	for(KEY_ITERATOR k = KeyReader::scancodes.begin(); k != KeyReader::scancodes.end(); k++)
	{
		int scancode = (*k);
		switch(scancode)
		{
			case KEY_DOWN:
				highlighted++;
				if (highlighted == optionCount)
					highlighted = 0;
				soundSys->playSound(SND_TOGGLE);
				break;
			case KEY_UP:
				highlighted--;
				if (highlighted == -1)
					highlighted = optionCount - 1;
				soundSys->playSound(SND_TOGGLE);
				break;
			case KEY_ENTER:
				selected = highlighted;
				soundSys->playSound(SND_SELECT);
				break;
		}
	}
		
}

/***********************************************/

void MenuWindow::render()
{
	glPushMatrix();
	glLoadIdentity();
	
	IWindow::render();
	
	double top = y + 24 + lines.size() * 16;
	
	TextRenderer *tr = TextHandler::getInstance()->getRenderer("wet");
	tr->setSize(0.28, 0.28);
	
	for (int i = 0; i < optionCount; i++)
		if (highlighted == i)
		{
			glColor3f(0.2, 0.6, 0.2);
			glRectangle(x + 16, top + i * 20, x + width - 16, top + i * 20 + 20);
			tr->render(x + width * 0.5, top + i * 20 + 10, 0.5, 0.5, GLColor(1.0, 1.0, 1.0), options[i].c_str());
		}
		else
		{
			tr->render(x + width * 0.5, top + i * 20 + 10, 0.5, 0.5, GLColor(0.5, 1.0, 0.5), options[i].c_str());
		}
		
	glPopMatrix();
}
