#include "../engine/GLRectangle.h"
#include "Blanket.h"

/**************************************************/

void Blanket::step(double dt)
{
	opacity -= 1.5 * dt;
}

void Blanket::render()
{
	glPushMatrix();
	glLoadIdentity();
	
	color.a = opacity;
	
	glDisable(GL_ALPHA_TEST);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	
	glColor4f(color.r, color.g, color.b, opacity);
	glRectangle(0.0, 0.0, 640.0, 480.0);
	
	glPopMatrix();
}
