#include <allegro.h>

#include "Settings.h"

/**************************************************/

int Settings::setting[LAST_SETTING];
char Settings::basePath[512];
char Settings::filenameBuffer[512];

/**************************************************/

const char *settingSections[LAST_SETTING] =
{
	"Graphics", "Sound", "Sound"
};

const char *settingNames[LAST_SETTING] =
{
	"fullscreen", "music", "sfx"
};

const int settingDefaults[LAST_SETTING] =
{
	0, 1, 1
};

/**************************************************/

void Settings::loadSettings()
{
	set_config_file("settings.ini");

	for (int i = 0; i < LAST_SETTING; i++)
		setting[i] = get_config_int(settingSections[i], settingNames[i], settingDefaults[i]);

	char tempPath[512];
	get_executable_name(tempPath, 512);
	replace_filename(basePath, tempPath, "", 512);
}

void Settings::saveSettings()
{
	set_config_file("settings.ini");
	
	for (int i = 0; i < LAST_SETTING; i++)
		set_config_int(settingSections[i], settingNames[i], setting[i]);
	
	flush_config_file();
}

char* Settings::path(const char *filenamePart)
{
	make_absolute_filename(filenameBuffer, basePath, filenamePart, 512);
	return filenameBuffer;
}
