#include <cmath>

#include <allegro.h>
#include <alleggl.h>
#include <gl/gl.h>
#include <glyph.h>

#include "GLBitmap.h"
#include "TimeKeeper.h"
#include "FPSCounter.h"
#include "TextRenderer.h"

static unsigned int updateTimer = 0;

GLBitmap *backBitmap, *testBitmap;
TimeKeeper *TK;
FPSCounter *fpsCounter;
TextRenderer *textRend;

/*GLYPH_FACE *arialFace;
GLYPH_REND *textRend;
GLYPH_KEEP *glyphKeep;
GLYPH_TEXTURE *glyphTex;*/

float x = 0.0, y = 0.0, rot = 0.0, scale = 1.0;
float numObjects = 10;
int frameSkip;

/********************************************************/

void initAllegro()
{
	allegro_init();
	install_allegro_gl();
	
	allegro_gl_set(AGL_DOUBLEBUFFER, true);
	allegro_gl_set(AGL_COLOR_DEPTH, 32);
	allegro_gl_set(AGL_RENDERMETHOD, true);
	allegro_gl_set(AGL_WINDOWED, true);
	allegro_gl_set(AGL_REQUIRE, AGL_DOUBLEBUFFER | AGL_COLOR_DEPTH | AGL_RENDERMETHOD | AGL_WINDOWED);
	
	set_color_depth(32);
	set_gfx_mode(GFX_OPENGL, 800, 600, 0, 0);
	
	install_timer();
	install_keyboard();
}

/***************************************************/

void setUpGL()
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, 800, 600, 0, 5, -5);
	glMatrixMode(GL_MODELVIEW);
	
	glClearColor(0.0, 0.0, 0.0, 0.0);
}

/***************************************************/

void init()
{
	initAllegro();
	setUpGL();
	
	// fonts
	textRend = TextRenderer::load("wet.bmp", "wet.metrics");
	
	// bitmaps
	backBitmap = GLBitmap::load("../../testgfx/back.tga", GLBitmap::TF_NO_ALPHA);
	testBitmap = GLBitmap::load("../../testgfx/anchor.tga");
	testBitmap->setOrigin(0.5, 0.5);

	// time controllers
	TK         = new TimeKeeper(0.01, 0.025, 2, false);
	fpsCounter = new FPSCounter();
}

/***************************************************/

void destroy()
{
	delete testBitmap;
	delete fpsCounter;
	delete TK;
	delete textRend;
}

/***************************************************/

void drawScene()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	
	backBitmap->draw(0.0, 0.0);
	
	glTranslatef(400.0, 300.0, 0.0);

	testBitmap->setTransparencyMode(GLBitmap::TM_ALPHA_ADDITIVE);
	testBitmap->setRotation(rot);
	testBitmap->setTint(GLColor(0.3, 0.1, 0.1));
	testBitmap->setScale(scale, scale);

	for (int i = 0; i < (int)numObjects; i++)
		testBitmap->draw(x * (float)i / (int)(numObjects - 1), y * (float) i / (int)(numObjects - 1));
	
	glTranslatef(-395.0, -282.0, 0.0);
	
	// FPS Counter
	
	textRend->printf(1.0, 1.0, 0.0, 0.0, GLColor(0.0, 0.0, 0.0, 1.0), "FPS count: %d", fpsCounter->getFPS());
	textRend->printf(0.0, 0.0, 0.0, 0.0, GLColor(1.0, 1.0, 0.0, 1.0), "FPS count: %d", fpsCounter->getFPS());
	
	textRend->printf(1.0, 21.0, 0.0, 0.0, GLColor(0.0, 0.0, 0.0), "Objects: %d", (int)numObjects);
	textRend->printf(0.0, 20.0, 0.0, 0.0, GLColor(1.0, 0.95, 0.0), "Objects: %d", (int)numObjects);

	textRend->printf(1.0, 41.0, 0.0, 0.0, GLColor(0.0, 0.0, 0.0), "Frameskip: %d", frameSkip);
	textRend->printf(0.0, 40.0, 0.0, 0.0, GLColor(1.0, 0.9, 0.0), "Frameskip: %d", frameSkip);

	allegro_gl_flip();
}

/***************************************************/

int main()
{
	init();
	
	bool exit = false;
	double delta;
	int internalFS;
	
	TK->reset();
	
	while(!exit)
	{
		delta = TK->getDT() * 100; // we want delta in 0.1s
		internalFS = frameSkip = TK->getFramesToSkip();
		do 
		{
			// logic
			
			if (key[KEY_Q])
				exit = true;
			if (key[KEY_LEFT])
				x -= delta * 2.0 * scale;
			if (key[KEY_RIGHT])
				x += delta * 2.0 * scale;
			if (key[KEY_UP])
				y -= delta * 2.0 * scale;
			if (key[KEY_DOWN])
				y += delta * 2.0 * scale;
			if (key[KEY_Z])
				rot += delta * 2.0;
			if (key[KEY_X])
				rot -= delta * 2.0;
			if (key[KEY_A])
				scale -= delta * 0.07;
			if (key[KEY_S])
				scale += delta * 0.07;
			if (key[KEY_EQUALS])
				numObjects += 0.3 * delta;
			if (key[KEY_MINUS] && numObjects >= 2.5)
				numObjects -= 0.3 * delta;
			if (key[KEY_BACKSLASH])
				numObjects += 1.0 * delta;
			if (key[KEY_BACKSPACE] && numObjects >= 2.9)
				numObjects -= 1.0 * delta;
			
		}while((internalFS--) > 0);

		// drawing
		fpsCounter->frameRendered();
		drawScene();
	}
	
	destroy();
	
	return 0;
}
END_OF_MAIN();
