#include <cmath>

#include "../engine/GLBitmap.h"
#include "../misc/Random.h"
#include "Rock.h"

/****************************************************/

GLBitmap *Rock::rockBMP = NULL;

/****************************************************/

Rock::Rock(double centerX, double centerY, double moveRadius, double speed, double angle)
	: cX(centerX), cY(centerY), mRadius(moveRadius), speed(speed), angle(angle)
{
	rotSpeed = randomFloat(1.0, 2.0);
	rotation = randomFloat(0, 2 * M_PI);
	
	step(0.0);
	double distX = x - 200.0, distY = y - 200.0;
	if ( (distX * distX + distY * distY) < 4900.0)
	{
		cX = -cX;
		cY = -cY;
		this->angle += M_PI;
		step(0.0);
	}
}

/****************************************************/

void Rock::step(double dt)
{
	angle += speed * dt;
	
	x = cX + std::cos(angle) * mRadius;
	y = cY - std::sin(angle) * mRadius;
	
	rotation += rotSpeed * dt;
};

/****************************************************/

void Rock::render()
{
	rockBMP->setOrigin(0.5, 0.5);
	rockBMP->setRotation(rotation * 180.0 / M_PI);
	rockBMP->draw(x, y);
}
