#ifndef _PLANET_H
#define _PLANET_H

/******************************************/

#include "../Classes.h"
#include "../entity/Entity.h"
#include "../engine/GLColor.h"

#include <string>

/******************************************/

class Planet : public Entity
{
	public:
	
	static Planet *lastVisited;
	
	Entity *anchor;
	
	double sRadius, mRadiusX, mRadiusY, speed, angle;
	
	GLColor color;
	std::string name;
	
	bool dockable, canFuel;
	double dockCounter, dockRadius, fuelRadius;
	
	double atmoSize, atmoType;
	double foodValue, hyperValue, eventValue;
	
	int kind;
	
	public:
		
	static GLBitmap *planetBMP[2], *atmoBMP;
	
	Planet(Entity *anchor, double radius, double mrX, double mrY, double speed, double angle, 
		 GLColor color, int kind, double foodValue, double hyperValue, double eventValue, double atmoSize, double atmoType, std::string name);
	
	int type() {return ETYPE_PLANET;};
	int stepPriority() {return 55;};
	int renderPriority() {return 55;};
	
	bool		isArea() {return true;};
	bool		contains(double x, double y);
	
	void		step(double dt);
	void		render();
	
	bool		checkDocking(Ship *ship, double dt);
	void		dock(Ship *ship, Panel *panel);
};

/******************************************/

#endif
