#ifndef _WINDOW_H
#define _WINDOW_H

/*********************************************/

#include <string>
#include <vector>

#include "../Classes.h"
#include "../entity/Entity.h"

/*********************************************/

class IWindow : public Entity
{
	public:
		
	void doWordWrap();
	std::vector<std::string> lines;
	std::string text;
	
	double width, height;
	bool alive;
	
	public:
	
	static GLBitmap *cornerBMP, *borderBMP;
	
	IWindow(std::string _text, int _width);
	
	int		type() {return ETYPE_WINDOW;};
	int		stepPriority() {return 100;};
	int		renderPriority() {return 1;};
	
	void step(double dt);
	void render();
	bool isAlive() {return alive;}
};

/*********************************************/

#endif
