#include <alleggl.h>
#include <string>

#include "../engine/GLRectangle.h"
#include "../engine/GLBitmap.h"
#include "../entity/GameWorld.h"
#include "../misc/TextHandler.h"
#include "../misc/KeyReader.h"
#include "../engine/TextRenderer.h"
#include "../sound/SoundSystem.h"

#include "IWindow.h"

using namespace std;

/*************************************************************/

GLBitmap *IWindow::cornerBMP = NULL;
GLBitmap *IWindow::borderBMP = NULL;

/*************************************************************/

void IWindow::doWordWrap()
{


  lines.clear();
	
  double textWidth;
  double columnWidth = width - 32.0;
	
  TextRenderer *tr = TextHandler::getInstance()->getRenderer("wet");
  tr->setSize(0.28, 0.28);

  string thisLine = "", oldLine = "", thisWord, wholeText = text;
  int spacePos;

  while(wholeText != "")
  {
    spacePos = wholeText.find(" ");
    if (spacePos < 0)
    {
      thisWord = wholeText;
      wholeText = "";
    }
    else
    {
      thisWord = wholeText.substr(0, spacePos);
      wholeText = wholeText.substr(spacePos + 1, wholeText.size() - spacePos - 1);
    }
    
    if (thisWord != "\n")
    {
	    if (thisLine == "")
		thisLine = thisWord;
	    else
		thisLine += " " + thisWord;
    }
    else
    {
	    lines.push_back(oldLine.c_str());
	    thisLine = "";
    }

    textWidth = tr->getWidth(thisLine.c_str());

    if (textWidth > columnWidth)
    {
      thisLine = thisWord;
	lines.push_back(oldLine.c_str());
    }

    oldLine = thisLine;
  }

  if (thisLine!="")
  {
	lines.push_back(thisLine.c_str());
  }
  
  height = 32 + lines.size() * 16.0;
  x = 320.0 - width * 0.5;
  y = 330.0 - height * 0.5;
}

/*********************************************************/

IWindow::IWindow(std::string _text, int _width)
	: text(_text), width(_width), alive(true)
{
	doWordWrap();
}

/*********************************************************/

void IWindow::step(double dt)
{
	for(KEY_ITERATOR k = KeyReader::scancodes.begin(); k != KeyReader::scancodes.end(); k++)
	{
		int scancode = (*k);
		if (scancode == KEY_ENTER)
		{
			alive = false;
			parent->paused = false;
			soundSys->playSound(SND_SELECT);
		}
	}
	
	if (!alive)
		KeyReader::update();
}

/*********************************************************/

void IWindow::render()
{
	glPushMatrix();
	glLoadIdentity();
	
	glColor3f(0.0, 0.0, 0.0);
	glRectangle(x + 16, y + 16, x + width - 16, y + height - 16);
	
	cornerBMP->setRotation(0.0);
	cornerBMP->draw(x, y);
	cornerBMP->setRotation(-90.0);
	cornerBMP->draw(x + width, y);
	cornerBMP->setRotation(-180.0);
	cornerBMP->draw(x + width, y + height);
	cornerBMP->setRotation(-270.0);
	cornerBMP->draw(x, y + height);
	
	borderBMP->setRotation(0.0);
	borderBMP->setScale( (width - 32) / 16.0, 1.0);
	borderBMP->draw(x + 16, y);
	borderBMP->setRotation(-180.0);
	borderBMP->draw(x + width - 16, y + height);
	borderBMP->setScale( (height - 32) / 16.0, 1.0);
	borderBMP->setRotation(-90.0);
	borderBMP->draw(x + width, y + 16);
	borderBMP->setRotation(-270.0);
	borderBMP->draw(x, y + height - 16);
	
	TextRenderer *tr = TextHandler::getInstance()->getRenderer("wet");
	tr->setSize(0.28, 0.28);
	
	for (unsigned int i = 0; i < lines.size(); i++)
	{
		tr->render(x + 16.0, y + 16.0 + i * 16.0, 0.0, 0.0, GLColor(1.0, 1.0, 1.0), lines[i].c_str());
	}
	
	glPopMatrix();
}
