#ifndef _ENTITY_H
#define _ENTITY_H

#include <allegro.h>
#include <list>

#include "../Classes.h"

using namespace std;

/***********************************************************/

#define EL_ITERATOR list<Entity*>::iterator

const int ETYPE_UNKNOWN = -1;
const int ETYPE_PLANET = 1;
const int ETYPE_ROCK = 2;
const int ETYPE_SUN = 3;
const int ETYPE_SHIP = 4;
const int ETYPE_FLARE = 5;

const int ETYPE_WINDOW = 255;


class Entity
{
	public:
		GameWorld	*parent;
		double	x, y;
	
	public:
		virtual int		type() {return ETYPE_UNKNOWN;};
		
		GameWorld*		getParent() {return parent;};
		void			setParent(GameWorld *world) {parent = world;};
		
		double		getX() {return x;};
		double		getY() {return y;};
		void			setX(double _x) {x = _x;};
		void			setY(double _y) {y = _y;};
		
		virtual int		stepPriority()	  {return -1;};
		virtual int		renderPriority()	  {return -1;};
		virtual int		collisionPriority() {return -1;};
		
		virtual void	step(double dt) {allegro_message("Ouch!");};
		virtual void	render() {};
		virtual bool	isAlive() {return true;};
		
		virtual bool	isArea() {return false;};
		virtual bool	contains(double x, double y) {return false;};
		virtual void	processCollision(Entity *area, Entity *collider) {};
		
		Entity()				{parent = NULL;};
		Entity(double _x, double _y)	{x = _x; y = _y; parent = NULL;};
		
		virtual ~Entity() {};
};

/***********************************************************/

#endif
