#include <cmath>
#include <vector>

#include "Stuff.h"

/******************************************************/

bool Model::pointInside(double x, double y)
{
	x = x - modelX;
	y = y - modelY;
	
	if (x + y > XYLimit)
		return false;
	
	x /= scale; y /= scale;
	
	double xOld = x, yOld = y;
	x = xOld * std::cos(-rotation) - yOld * std::sin(-rotation);
	y = -xOld * std::sin(-rotation) - yOld * std::cos(-rotation);
	
	for (unsigned int i = 0; i < quads.size(); i++)
		if (quads[i].pointInside(x, y))
			return true;
	
	return false;
}
