#ifndef _SUN_H
#define _SUN_H

/*********************************************/

#include "../entity/Entity.h"

/*********************************************/

const int NUM_PARTICLES = 160;

struct SunParticle
{
	double x, y;
	double vx, vy;
	double life, power;
};

class Sun : public Entity
{
	public:
	
	list<Entity*> pulledObjects;
	
	SunParticle particle[NUM_PARTICLES];
	void newParticle(SunParticle *p);
	
	static GLBitmap *sunBMP, *particleBMP;
	
	public:
		
	Sun();
	
	int		type() {return ETYPE_SUN;};
	int		renderPriority() {return 40;};
	int		stepPriority() {return 50;};
	
	void		step(double dt);
	void		render();
	
	bool		isArea() {return true;};
	bool		contains(double x, double y);
	
	void		targetShip();
};

/*********************************************/

#endif
