#ifndef _SHIP_H
#define _SHIP_H

/***************************************************/

#include "../things/Artifact.h"
#include "../things/Mover.h"
#include "../collision/Stuff.h"
#include "../Classes.h"

/***************************************************/

class Ship : public Mover
{

	public:
		
	// MY HEART BLEEEEEEEDS!
	
	Model colModel;
	
	Panel *panel;
	Planet *attachedTo;
	
	double relX, relY;
	
	double angle;
	
	double food, power, fuel, hyper;
	double foodCap, powerCap, fuelCap, hyperCap;
	
	bool aliveFlag;
	
	double hyperCounter;
	bool canDock, canFuel, canHyper, goHyper, hypered;
	
	int thrustSound;

	list<Entity*> planets;
	
	bool		hasArtifact[ARTIFACT_COUNT];
	
	//--------------------------------------
	
	public:
	
	static GLBitmap *shipBMP, *shieldBMP;
	//--------------------------------------
	
	public:
	
	Ship(double x, double y);
	~Ship();
	
	int		type() {return ETYPE_SHIP;};
	int		renderPriority() {return 50;};
	int		stepPriority()	{return 50;};
	int		collisionPriority()	{return 50;};
	
	bool		isAlive() {return aliveFlag;};
	
	void		step(double dt);
	void		render();
	
	bool		isArea() {return true;};
	bool		contains(double x, double y);
	void		processCollision(Entity *area, Entity *collider);
	
	void		renewPlanets();
	void		showArtifacts();
};

/***************************************************/

#endif
