#include <alleggl.h>

#include "../entity/Entity.h"
#include "../entity/GameWorld.h"
#include "../engine/GLBitmap.h"
#include "../engine/GLRectangle.h"
#include "../things/Ship.h"
#include "../things/Planet.h"
#include "Panel.h"

/*******************************************************/

GLBitmap *Panel::panelBMP = NULL;

/*******************************************************/

void Panel::figureOutMapScale()
{
	planets = world->getEntitiesOfType(ETYPE_PLANET);
	
	mapScale = 1.0;
	for(EL_ITERATOR it = planets.begin(); it != planets.end(); it++)
	{
		Planet *p = (Planet*)(*it);
		
		double newScale;
		if (p->mRadiusX > p->mRadiusY)
			newScale = 50.0 / p->mRadiusX;
		else
			newScale = 50.0 / p->mRadiusY;
		
		if (newScale < mapScale)
			mapScale = newScale;
	}
}

/*******************************************************/

void Panel::render()
{
	glPushMatrix();
	glLoadIdentity();
	
	panelBMP->draw(2.0, 2.0);
	
	double length[4], cap[3];
	length[0] = ship->fuel / 300.0;
	length[1] = ship->power / 150.0;
	length[2] = ship->food / 150.0;
	cap[0] = (int)(50.0 + ship->fuelCap / 4.0) + 1;
	cap[1] = (int)(50.0 + ship->powerCap / 2.0) + 1;
	cap[2] = (int)(50.0 + ship->foodCap / 2.0) + 1;
	
	length[3] = ship->hyper / ship->hyperCap;
	
	for (int i = 0; i < 4; i++)
	{
		if (i != 3)
		{
			if (length[i] > 0.2)
				glColor3f(0.0, 0.6, 0.0);
			else if (length[i] > 0.1)
				glColor3f(1.0, 0.9, 0.0);
			else
				glColor3f(0.8, 0.0, 0.0);
		}
		else
		{
			if (length[i] == 1.0)
				glColor3f(1.0, 1.0, 1.0);
			else
				glColor3f(0.5, 0.0, 1.0);
		}
		
		glRectangle(50.0, 148.0 + i * 10.0, 50.0 + length[i] * 75.0, 151.0 + i * 10.0);
		
		glColor3f(1.0, 1.0, 1.0);
		if (i != 3)
			glRectangle(cap[i], 147.0 + i * 10.0, cap[i] + 1, 152.0 + i * 10.0);
	}
	
	glColor3f(1.0, 1.0, 0.0);
	glRectangle(68.0, 69.0, 73.0, 72.0);
	glRectangle(69.0, 68.0, 72.0, 73.0);
	glColor3f(1.0, 1.0, 1.0);
	glRectangle(69.0, 69.0, 72.0, 72.0);
	
	Planet *p;
	for(EL_ITERATOR it = planets.begin()++; it != planets.end(); it++)
	{
		p = (Planet*)(*it);
		
		double drawX = 70.0 + p->getX() * mapScale;
		double drawY = 70.0 + p->getY() * mapScale;

		p->color.set();
		if (!p->anchor)
			glRectangle(drawX - 1, drawY - 1, drawX + 2, drawY + 2);
		else
			glRectangle(drawX, drawY, drawX + 1, drawY + 1);
	}
	
	double drawX = 70.0 + ship->getX() * mapScale;
	double drawY = 70.0 + ship->getY() * mapScale;
	if (drawX > 15.0 && drawX < 125.0 && drawY > 15.0 && drawY < 125.0)
	{
		glColor3f(1.0, 1.0, 1.0);
		glRectangle(drawX, drawY, drawX + 1, drawY + 1);
	}
	
	glPopMatrix();
}
