#include <cmath>
#include <string>

#include "MineWindow.h"

#include "../engine/TextRenderer.h"
#include "../misc/TextHandler.h"
#include "../engine/GLRectangle.h"
#include "../things/Planet.h"
#include "../things/Ship.h"
#include "../sound/SoundSystem.h"
#include "../misc/Random.h"

/*****************************************************/

int MineWindow::miningDifficulty = 1;

/*****************************************************/

MineWindow::MineWindow(Planet *planet, Ship *ship)
	: IWindow("Mining: Press B when ready, then press A each time the cursor is over the green area to mine. First miss ends the process.", 432),
	planet(planet), ship(ship)
{
	height += 46;
	
	going = gone = done = hit = false;
	amountMined = 0;
	cursorPos = 0.0;
	cursorDir = 1;
	time = 0.0;
}

/*****************************************************/

void MineWindow::step(double dt)
{
	if (key[KEY_X] && (!going))
		going = true;
	
	if (key[KEY_ENTER] && gone)
		done = true;
	
	if (going && !gone)
	{
		if (key[KEY_Z] && !hit)
		{
			hit = true;
			if (std::abs(cursorPos - 0.5) * 400.0 < planet->hyperValue)
			{
				planet->hyperValue -= 4.0;
				
				int acquired = randomInt(4, 5);
				ship->hyper += acquired;
				amountMined += acquired;
				
				if (ship->hyper > ship->hyperCap)
					ship->hyper = ship->hyperCap;
				
				soundSys->playSound(SND_PICKFLARE);
			}
			else
			{
				soundSys->playSound(SND_INFO, 128, 0.7, 0.8);
				done = true;
			}
		}
		
		time += dt;
		
		double cspeed = 1.23 + miningDifficulty * 0.07;
		if (ship->hasArtifact[DRILL])
			cspeed -= 0.1;
		
		cursorPos += cspeed * dt * cursorDir;
		if (cursorPos > 1.0)
		{
			cursorPos = 2.0 - cursorPos;
			cursorDir = -1;
			hit = false;
		}
		else if (cursorPos < 0.0)
		{
			cursorPos = -cursorPos;
			cursorDir = 1;
			hit = false;
		}
		
		//if (time > 4.6)
		//	gone = true;
	}
}

/*****************************************************/

void MineWindow::render()
{
	IWindow::render();
	
	double top = y + 24 + lines.size() * 16;
	
	if (!gone)
	{
		glColor3f(0.4, 0.4, 0.7);
		glRectangle(x + 16, top, x + 416, top + 10);
		glColor3f(0.6, 0.6, 0.9);
		glRectangle(x + 16, top + 2, x + 416, top + 5);
	}
	
	if (going && !gone && planet->hyperValue > 0.0)
	{
		double xBegin = x + 216 - planet->hyperValue;
		double xEnd = x + 216 + planet->hyperValue;
		glColor3f(0.0, 0.0, 0.0);
		glRectangle(xBegin - 1, top, xEnd + 1, top + 10);
		glColor3f(0.4, 0.8, 0.4);
		glRectangle(xBegin, top, xEnd, top + 10);
		glColor3f(0.6, 1.0, 0.6);
		glRectangle(xBegin, top + 2, xEnd, top + 5);
	}
	if (!gone)
	{
		double cursorX = x + 16 + (cursorPos * 400.0);
		glColor3f(0.0, 0.0, 0.0);
		glRectangle(cursorX - 2, top - 2, cursorX + 3, top + 12);
		if (!hit)
			glColor3f(1.0, 1.0, 1.0);
		else
			glColor3f(0.7, 0.7, 0.7);
		glRectangle(cursorX - 1, top - 1, cursorX + 2, top + 11);
	}
	
	TextRenderer *tr = TextHandler::getInstance()->getRenderer("wet");
	tr->setSize(0.28, 0.28);
	
	if (gone)
		tr->render(320.0, top + 18, 0.5, 0.0, GLColor(1.0, 1.0, 1.0), "Press Start to continue.");
	else if (going)
		tr->printf(x + 16, top + 18, 0.0, 0.0, GLColor(1.0, 1.0, 1.0), "Acquired amount: %d", amountMined);
}
