#include <alleggl.h>

#include "../engine/GLBitmap.h"
#include "Info.h"

/******************************************/

GLBitmap *Info::infoBMP[3];

/******************************************/

Info::Info(int kind)
	: kind(kind)
{
	x = (int)(320.0 - infoBMP[kind]->getWidth() * 0.5);
	y = 85.0 + kind * 20.0;
}

/******************************************/

void Info::render()
{
	glPushMatrix();
	glLoadIdentity();
	
	infoBMP[kind]->draw(x, y);
	
	glPopMatrix();
}
