#ifndef _GAMEWORLD_H
#define _GAMEWORLD_H

/***********************************************************/

#include <list>

#include "../Classes.h"

using namespace std;

/***********************************************************/

class GameWorld
{
	private:
		list <Entity*>	masterList, typedList, autoDestroyList, renderSorted, stepSorted, areas, colSorted;
		list <Entity*>	removeQueue;
	
		void		insertIntoList(list<Entity*>& elist, Entity *e, bool (*greaterFunc)(Entity*, Entity*) );
	
	public:
		bool paused;
	
		void		add(Entity *e, bool autoDestroy);
		void		remove(Entity *e);
	
		int			getEntityCount() {return masterList.size();};
		list<Entity*>	getEntities();
		list<Entity*>	getEntitiesOfType(int type);
		int			countEntitiesOfType(int type);
		
		void		processStep(double dt);
		void		processCollisions();
		void		processRender();
	
		GameWorld();
		~GameWorld();
};

/***********************************************************/

#endif
