#ifndef _STARS_H
#define _STARS_H

/*****************************************************/

#include "../Classes.h"
#include "../entity/Entity.h"

/*****************************************************/

struct Star
{
	double x, y, z;
};

class Starfield : public Entity
{
	private:
	
	int starCount;
	Star *stars;
	Ship *ship;
	
	void resetStar(Star *star);
	
	public:
	
	int renderPriority() {return 60;};
	int stepPriority() {return 50;};
	
	void step(double dt);
	void render();
	
	Starfield(Ship * ship, int numStars);
	~Starfield();
};

/*****************************************************/

#endif
