#include <alleggl.h>

#include "../misc/Random.h"
#include "../things/Ship.h"

#include "Starfield.h"

/********************************************/

Starfield::Starfield(Ship *_ship, int numStars)
{
	ship = _ship;
	starCount = numStars;
	
	stars = new Star[starCount];
	for (int i = 0; i < starCount; i++)
	{
		stars[i].x = randomFloat(0.0, 640.0);
		stars[i].y = randomFloat(0.0, 480.0);
		stars[i].z = randomFloat(0.5, 1.0);
	}
}

Starfield::~Starfield()
{
	delete [] stars;
}

/********************************************/

void Starfield::resetStar(Star *star)
{
	
	while (star->x < 0.0)
		star->x += 640.0;
	while (star->x > 640.0)
		star->x -= 640.0;
	while (star->y < 0.0)
		star->y += 480.0;
	while (star->y > 480.0)
		star->y -= 480.0;
}

/********************************************/

void Starfield::step(double dt)
{
	for(int i = 0; i < starCount; i++)
	{
		stars[i].x -= ship->vx * dt * stars[i].z;
		stars[i].y -= ship->vy * dt * stars[i].z;
		
		if (stars[i].x < 0.0 || stars[i].y < 0.0 || stars[i].x > 640.0 || stars[i].y > 480.0)
			resetStar(&stars[i]);
	}
}

/********************************************/

void Starfield::render()
{
	glBegin(GL_POINTS);
	for (int i = 0; i < starCount; i++)
	{
		glColor3f(stars[i].z * 0.7, stars[i].z * 0.4, stars[i].z);
		glVertex2f(stars[i].x + ship->getX() - 320.0, stars[i].y + ship->getY() - 240.0);
	}
	glEnd();
}
