#ifndef _ROCK_H
#define _ROCK_H

/*********************************************/

#include "../Classes.h"
#include "../entity/Entity.h"

/*********************************************/

class Rock : public Entity
{
	public:
		
	double cX, cY, mRadius, speed, angle;
	double rotation, rotSpeed;
	
	public:
	
	static GLBitmap *rockBMP;
	
	int		type() {return ETYPE_ROCK;};
	int		renderPriority() {return 45;};
	int		stepPriority() {return 50;};
	int		collisionPriority() {return 40;};
	
	void		step(double dt);
	void		render();
	
	Rock(double centerX, double centerY, double moveRadius, double speed, double angle);
};

/*********************************************/

#endif
