#ifndef _MOVER_H
#define _MOVER_H

#include "../entity/Entity.h"

class Mover : public Entity
{
	public:
		double vx, vy;
	
		Mover(double x, double y) : Entity(x, y) {};
		Mover(double x, double y, double vx, double vy) : Entity(x, y), vx(vx), vy(vy) {};
			
		void step(double dt)
		{
			x += vx * dt;
			y += vy * dt;
		};
};

#endif
