#ifndef _COLSTUFF_H
#define _COLSTUFF_H

/*********************************************************/

#include <vector>

/*********************************************************/

struct Quad
{
	double x1, y1, x2, y2;
	
	Quad(double x1, double y1, double x2, double y2)
		: x1(x1), y1(y1), x2(x2), y2(y2) {};
	
	bool pointInside(double x, double y)
	{
		return (x1 <= x && x <= x2 && y1 <= y && y <= y2);
	}
};

struct Model
{
	std::vector<Quad> quads;
	
	double modelX, modelY;
	double rotation, scale;
	double XYLimit;
	
	bool pointInside(double x, double y);
};

#endif
