#ifndef UNIT_H
#define UNIT_H

#include <list>
#include <allegro.h>

class unit {
    
    int x, y;
    int w, h;
    
protected:
    
    void setw(int);
    void seth(int);
    
    virtual void oncollide(unit*);
    
public:
    
    bool setpos(int x, int y, int flags = 0);
    
    unit();
    virtual ~unit();
    
    int getx();
    int gety();

    int getw();
    int geth();
    
    static const int normal;
    static const int kill;
    static const int force;
    static const int closest;
    
    virtual int think();
    virtual void draw(BITMAP*, int x, int y);
    
    static void set_unit_list(std::list<unit*>*);
    static std::list<unit*> *get_unit_list();
    
private:

    void findclosest(int x, int y);
    unit *doescollide(int x, int y, int w, int h);
};

#endif
