#include "unit.h"
#include "tile.h"
#include <cmath>
#include <iostream>
using namespace std;
using namespace tileengine;

const int unit::normal = 0;
const int unit::kill = 1;
const int unit::force = 2;
const int unit::closest = 4;

bool unit::setpos(int x_, int y_, int flags)
{
    tilemap *guide = tilemap::get_collision_layer();
    unit *guy = doescollide(x_, y_, w, h);
    
    if(guy)
        oncollide(guy), guy->oncollide(this);
    
    if(flags & force) {
        
        y = y_;
        x = x_;
        
        return true;
    }
    
    if(guide && guide->intercepts(x_, y_, x_ + w, y_ + h)) {
        
        if(flags & closest)
            findclosest(x_, y_);
        else
            return false;
    }
    else {
        
        x = x_;
        y = y_;
    }
    
    return true;
}

void unit::setw(int W)
{
    w = W;
}

void unit::seth(int H)
{
    h = H;
}

void unit::oncollide(unit*)
{

}

unit::unit()
    : x(0), y(0), w(0), h(0)
{

}

unit::~unit()
{

}

int unit::getx()
{
    return x;
}

int unit::gety()
{
    return y;
}

int unit::getw()
{
    return w;
}

int unit::geth()
{
    return h;
}

int unit::think()
{
    return normal;
}

void unit::draw(BITMAP*, int, int)
{

}

// Spirals out from specified point looking for suitable position

void unit::findclosest(int x, int y)
{
    static const float Pi = 3.1416;
    static const float radian_change = Pi / 4;
    static const float radius_accel = 4;
    float radius_change = 1;
    float radian = 0;
    float radius = 0;

    int ox = x;
    int oy = y;

    do {
        
        radian += radian_change;
        radius += radius_change;
        radius_change += radius_accel;
        
        x = (int)(ox + cosf(radian) * radius);
        y = (int)(oy - sinf(radian) * radius);
        
    } while(!setpos(x, y, 0));
}

unit *unit::doescollide(int x, int y, int w, int h)
{
    if(0 == get_unit_list())
        return 0;

    // Adjust size of bounding box

    int wchange = (int)ceil(w - w * 0.2);
    int hchange = (int)ceil(h - h * 0.4);

    x += wchange / 2;
    w -= wchange;
    y += hchange / 2;
    h -= hchange;

    for(list<unit*>::iterator itr = get_unit_list()->begin();
        itr != get_unit_list()->end(); ++itr) {

        if(!(*itr == this
            || x     > (*itr)->x + (*itr)->w
            || x + w < (*itr)->x
            || y     > (*itr)->y + (*itr)->h
            || y + h < (*itr)->y))
            return *itr;
    }

    return 0;
}

static list<unit*> *unit_list = 0;

void unit::set_unit_list(list<unit*> *ul)
{
    unit_list = ul;
}

list<unit*> *unit::get_unit_list()
{
    return unit_list;
}
