#include <fstream>
#include <cmath>
#include <sstream>
#include "tile.h"
#include "datafile.h"
using namespace tileengine;
using namespace std;

tileengine::tile tileengine::tile_factory(const string &name, int flags)
{
    return tile((BITMAP*)datafile.find(name.c_str()), flags);
}

tile::tile(BITMAP *bmp_, int flags_) : bmp(bmp_), flags(flags_)
{
    
}

cloud::cloud(int w, bool menu) : width(w)
{
    bmp = (rand()%2) ? (BITMAP*)datafile.find("OBJECT/CLOUD_BIG0") : (BITMAP*)datafile.find("OBJECT/CLOUD_SMALL0");
    leftface = true;
    flip = rand()%4;
    x = -250;
    y = 10 + (rand()%(SCREEN_H - 50));
    speed = 1 + (menu ? (rand()%2) : 0);
    
    if(!(rand()%10))
        speed++;
}

void cloud::draw(BITMAP *dest, int xscroll)
{
    (!flip ? draw_sprite : (flip == 1 ? draw_sprite_h_flip : (flip == 2 ? draw_sprite_v_flip : draw_sprite_vh_flip)))(dest, bmp, x - xscroll, y);
}

void cloud::process()
{
    x += speed;
}

bool cloud::done()
{
    return x > width;
}

void tilemap::generate(int seed)
{
    int width = 10000 + (rand() % 400);
    
    cloud_density = 2 + (rand()%100);
    
    sun = (BITMAP*)datafile.find("OBJECT/SUN");
    
    int hillmode = 0;
    const int dune1 = 1;
    const int dune3 = 2;
    int hillstart = 0;
    
    for(int i = 0; i * 32 < width; i++) {
        
        if(!hillmode) {
            
            hillmode = 1 + (rand()%2);
            hillstart = i;
        }
        
        int num;
        
        if(hillmode == dune1) {
            
            num = i - hillstart;
            
            if(num == 3)
                hillmode = 0;
        }
        else {
            
            if(i - hillstart < 3)
                num = i - hillstart;
            else if(i - hillstart < 6)
                num = (i - hillstart) + 1;
            else if(i - hillstart == 6)
                num = 1;
            else if(i - hillstart == 7)
                num = 2;
            else if(i - hillstart == 8) {
                
                num = 3;
                hillmode = 0;
            }
        }
        
        ostringstream os;
        os << "TILE" << num;
        
        hills.push_back(tile_factory(os.str()));
    }
    
    int since_skull = 0;
    bool hole = 0;
    int latehole = 0;
    int istart = 0;
    int holelength = 0;
    
    bool platform = 0;
    int platformlength = 0;
    int platformy = 0;
    
    bool steps = 0;
    bool direction = 0;
    
    bool pyramid = 0;
    int pyramidlength = 0;
    
    bool box = 0;
    int boxheight = 0;
    
    for(int i = 0; i * 32 < width; i++) {
        
        if(i > 1) {
            
            if(!(rand()%25) && !hole && latehole < 0 && !steps && !pyramid && !box) {
                
                hole = true, istart = i, holelength = 2 + (rand()%4);
                latehole = holelength + 5;
            }
            
            latehole--;
            
            if(!(rand()%50) && !platform && !steps && !pyramid && !box)
                platform = true, istart = i, platformlength = 2 + (rand()%10), platformy = 1 + (rand()%3);
            
            if(!(rand()%60) && !platform && !steps && !pyramid && !hole && !box)
                steps = true, istart = i, direction = rand()%2;
            
            if(!(rand()%60) && !platform && !steps && !pyramid && !hole && !box)
                pyramid = true, istart = i, pyramidlength = rand()%10;
            
            if(!(rand()%30) && !platform && !steps && !pyramid && !hole && !box)
                box = true, istart = i, boxheight = 1 + (rand()%2);
        }
        
        for(int j = 0; j < 15; j++) {
            
            if(i == width / 32 - 1 && j == 3) {
                
                tiles.push_back(tile_factory("OBJECT/PLATFORM", solid));
                continue;
            }
            
            if(i == width / 32 - 1 && j == 2) {
                
                tiles.push_back(tile_factory("OBJECT/DOOROPEN"));
                continue;
            }
            
            if(i == 1 && j == 3) {
                
                tiles.push_back(tile_factory("OBJECT/DOORCLOSE"));
                continue;
            }
            
            if(hole) {
                
                if((i - istart) - 1 >= holelength && j == 6)
                    hole = false;
                
                if(j == 4 && i - istart == 0)
                    tiles.push_back(tile_factory("TILE12", solid));
                
                else if(j > 4 && i - istart == 0)
                    tiles.push_back(tile_factory("TILE14", solid));
                
                else if(j > 3 && j < 5 && (i - istart) - 1 < holelength)
                    tiles.push_back(tile_factory("TILE11"));
                
                else if(j == 5 && (i - istart) - 1 < holelength)
                    tiles.push_back(tile_factory("TILE16", spike));
                
                else if(j == 4 && (i - istart) - 1 >= holelength)
                    tiles.push_back(tile_factory("TILE13", solid));
                
                else if(j > 4 && (i - istart) - 1 >= holelength)
                    
                    tiles.push_back(tile_factory("TILE15", solid));
                
                else
                    goto holecont;
                
                continue;
                
                holecont:;
            }
            
            if(platform) {
                
                if(i - istart >= platformlength)
                    platform = false;
                
                if(j == platformy && i - istart < platformlength)
                    tiles.push_back(tile_factory("OBJECT/PLATFORM", solid));
                else
                    goto platformcont;
                
                continue;
                
                platformcont:;
            }
            
            if(steps) {
                
                if(direction) {
                    
                    if(j == 3 && i - istart == 0)
                        tiles.push_back(tile_factory("OBJECT/BLOCKTOP", solid));
                    else if(j == 4 && i - istart == 0)
                        tiles.push_back(tile_factory("OBJECT/BLOCKBOTTOM", solid));
                    
                    else if(j == 2 && i - istart == 1)
                        tiles.push_back(tile_factory("OBJECT/BLOCKTOP", solid));
                    else if(j == 3 && i - istart == 1)
                        tiles.push_back(tile_factory("OBJECT/BLOCKSTACKTOP", solid));
                    else if(j == 4 && i - istart == 1) {
                        
                        tiles.push_back(tile_factory("OBJECT/BLOCKBOTTOM", solid));
                        steps = false;
                    }
                    else
                        goto stepcont;
                }
                else {
                    
                    if(j == 2 && i - istart == 0)
                        tiles.push_back(tile_factory("OBJECT/BLOCKTOP", solid));
                    else if(j == 3 && i - istart == 0)
                        tiles.push_back(tile_factory("OBJECT/BLOCKSTACKTOP", solid));
                    else if(j == 4 && i - istart == 0)
                        tiles.push_back(tile_factory("OBJECT/BLOCKBOTTOM", solid));
                    
                    else if(j == 3 && i - istart == 1)
                        tiles.push_back(tile_factory("OBJECT/BLOCKTOP", solid));
                    else if(j == 4 && i - istart == 1) {
                        
                        tiles.push_back(tile_factory("OBJECT/BLOCKBOTTOM", solid));
                        steps = false;
                    }
                    else
                        goto stepcont;
                }
                
                continue;
                
                stepcont:;
            }
            
            if(box) {
                
                if(boxheight == 2 && j == 2)
                    tiles.push_back(tile_factory("OBJECT/BLOCKTOP", solid));
                else if(boxheight == 2 && j == 3)
                    tiles.push_back(tile_factory("OBJECT/BLOCKSTACKTOP", solid));
                else if(boxheight == 1 && j == 3)
                    tiles.push_back(tile_factory("OBJECT/BLOCKTOP", solid));
                else if(j == 4) {
                    
                    tiles.push_back(tile_factory("OBJECT/BLOCKBOTTOM", solid));
                    box = false;
                }
                else goto boxcont;
                
                continue;
                
                boxcont:;
            }
            
            if(pyramid) {
                
                pyramid = false;
                
                // unused for now, depends on future graphics
            }
            
            if(j == 3 && !(rand()%20) && !hole) {
                
                tiles.push_back(tile_factory("OBJECT/CACTUS0", spike));
                
            } else if(j == 4)
                tiles.push_back(tile_factory("TILE7", solid));
            else if(j > 4) {
                
                if(!(rand()%10) && --since_skull <= 0 && !hole) {
                    
                    tiles.push_back(tile_factory("TILE9", solid));
                    since_skull = 5;
                }
                else
                    tiles.push_back(tile_factory("TILE8", solid));
                
            } else
                tiles.push_back(tile_factory("blank"));
            
        }
    }
    
    for(int i = 0; i < 6000; i++) {
        
        for(list<cloud>::iterator itr = clouds.begin(); itr != clouds.end(); ++itr) {
            
            itr->process();
        }
        
        if(!(rand()%cloud_density))
            clouds.push_back(cloud(hills.size() * 64));
    }
}

void tilemap::draw(BITMAP *dest, int xscroll)
{
    int row = 0;
    int col = 0;

    xscroll = MAX(0, xscroll);
    xscroll = MIN(xscroll, (signed)(tiles.size() / 15) * 32 + SCREEN_W);
    
    double scroll = (double)xscroll / getw();
    
    draw_sprite(dest, sun, (int)(SCREEN_W * scroll), (int)(100 - sin(3.14159265 * scroll) * 100));
    
    for(list<cloud>::iterator itr = clouds.begin(); itr != clouds.end(); ) {
        
        itr->draw(dest, xscroll);
        itr->process();
        
        if(itr->done())
            itr = clouds.erase(itr);
        else
            ++itr;
    }
    
    if(!(rand()%cloud_density))
        clouds.push_back(cloud(hills.size() * 64));
    
    int hillx = (xscroll % 64) / -2;
    
    for(vector<tile>::iterator itr = hills.begin() + xscroll / 64; itr != hills.end(); ++itr, hillx += 32) {
        
        draw_sprite(dest, itr->bmp, hillx, 128 - itr->bmp->h);
    }
    
    for(vector<tile>::iterator itr = tiles.begin() + (15 * (xscroll / 32)); itr != tiles.end(); ++itr) {
        
        if(col * 32 > SCREEN_W)
            break;
        
        if(row == 15) {
            col++;
            row = 0;
        }
        
        if(itr->bmp && row > 3)
            draw_sprite(dest, itr->bmp, col * 32 - xscroll % 32, row * 32);
        
        row++;
    }
    
    row = 0;
    col = 0;
    
    for(vector<tile>::iterator itr = tiles.begin() + (15 * (xscroll / 32)); itr != tiles.end(); ++itr) {
        
        if(col * 32 > SCREEN_W)
            break;
        
        if(row == 15) {
            col++;
            row = 0;
        }
        
        if(itr->bmp && row == 3)
            draw_sprite(dest, itr->bmp, col * 32 - xscroll % 32, row * 32);
        
        row++;
    }
    
    row = 0;
    col = 0;
    
    for(vector<tile>::iterator itr = tiles.begin() + (15 * (xscroll / 32)); itr != tiles.end(); ++itr) {
        
        if(col * 32 > SCREEN_W)
            break;
        
        if(row == 15) {
            col++;
            row = 0;
        }
        
        if(itr->bmp && row <= 2)
            draw_sprite(dest, itr->bmp, col * 32 - xscroll % 32, row * 32);
        
        row++;
    }
}

bool tilemap::intercepts(int x1, int y1, int x2, int y2, int flag)
{ 
    if(x1 > x2)
        swap(x1, x2);
    if(y1 > y2)
        swap(y1, y2);
    
    y2 -= 10;
    
    if(y1 > y2)
        swap(y1, y2);
    
    if(y1 < 0 || y2 > SCREEN_H && flag & solid)
        return true;
    
    if(x1 < 0 || x2 > getw() && flag & solid)
        return true;
    
    tile *start = &tiles[(x1 / 32) * 15 + (y1 / 32)];
    tile *second = start;
    tile *end = &tiles[(x2 / 32) * 15 + (y2 / 32)];
    tile *third = end;
    
    while(second + 15 < end)
        second += 15;
    
    while(third - 15 > start)
        third -= 15;
        
    if(start->flags & flag)
        return true;
    
    if(second->flags & flag)
        return true;
    
    if(third->flags & flag)
        return true;
    
    if(end->flags & flag)
        return true;
    
    return false;
}

static tilemap *collision_layer = 0;

void tilemap::set_collision_layer(tilemap *cl)
{
    collision_layer = cl;
}

tilemap *tilemap::get_collision_layer()
{
    return collision_layer;
}

int tilemap::getw()
{
    return (signed)(32 * tiles.size() / 15);
}

int tilemap::geth()
{
    return 15 * 32;
}
