#ifndef PLAYER_H
#define PLAYER_H

#include "unit.h"
#include "stopwatch.h"
#include "animation.h"

class player : public unit {
    
    animation walk;
    animation stand;
    animation idle;
    animation shooting;
    animation die;
    animation death;
    animation jumpup;
    animation jumpapex;
    animation jumpdown;
    
    animation *mode;
    
    bool onground;
    double jumpfactor;
    
    bool leftface;
    
    stopwatch clock;
    stopwatch modeclock;
    stopwatch idleclock;
    
    bool jumpkey;
    int jumps;
    
public:
    
    stopwatch shotclock;
    
    player();
    virtual ~player();
    
    virtual int think();
    virtual void draw(BITMAP*, int x, int y);
    
    void hurt();
    
    int left, right;
    int fire, jump;
    
    int hearts;
    
    static void set_player(player*);
    static player *get_player();
};

#endif
