#include "player.h"
#include "datafile.h"
#include "bullet.h"
#include "dumbo.h"
#include "tile.h"
#include <iostream>
using namespace std;

player::player()
    : walk("OBJECT/ANGEL/WALK"),
      stand("OBJECT/ANGEL/STAND"),
      idle("OBJECT/ANGEL/IDLE"),
      shooting("OBJECT/ANGEL/SHOOTING"),
      die("OBJECT/ANGEL/DIE"),
      death("OBJECT/ANGEL/DEATH"),
      jumpup("OBJECT/ANGEL/JUMPUP"),
      jumpapex("OBJECT/ANGEL/JUMPAPEX"),
      jumpdown("OBJECT/ANGEL/JUMPDOWN"),
      onground(0), jumpfactor(0), leftface(0), jumpkey(0), hearts(5)
{
    setw(17);
    seth(26);
    setpos(37, 96);
    
    left = KEY_LEFT;
    right = KEY_RIGHT;
    jump = KEY_UP;
    fire = KEY_RCONTROL;
}

player::~player()
{
    
}

int player::think()
{
    if(!hearts)
        return normal;
    
    int x = getx(), y = gety();
    int ox = x, oy = y;
    
    y -= (int)jumpfactor;
    jumpfactor -= .1;
    
    if(jumpfactor < -4)
        jumpfactor = -4;
    if(jumpfactor > 4)
        jumpfactor = 4;
    
    if(key[left]) {
        
        x -= 3;
        leftface = 1;
        
        if(modeclock.check())
            mode = &walk;
        
        idleclock.start(25);
    }
    
    else if(key[right]) {
        
        x += 3;
        leftface = 0;
        
        if(modeclock.check())
            mode = &walk;
        
        idleclock.start(25);
    }
    
    else if(modeclock.check() && (idleclock.check() || mode != &idle))
        mode = &stand;
    
    if(key[jump] && !jumpkey) {
        
        if(tileengine::tilemap::get_collision_layer()->intercepts(getx() + getw() / 2, gety() + geth(), getx() + getw() / 2, gety() + geth())) {
            
            jumpfactor = 3;
            jumps = 2;
        }
        else if(jumps-- > 0) {
            
            jumpfactor = 3;
        }
        else
            goto skipsound;
        
#ifndef NOSOUND
        extern SAMPLE *jump;
        play_sample(jump, 255, 127, 1000, 0);
#endif
        skipsound:;
        
        idleclock.start(25);
    }
    
    jumpkey = key[jump];
    
    if(key[fire] && shotclock.check()) {
        
        shotclock.start(10);
        
        bullet *bul = new bullet(this, leftface);
        bul->setpos(leftface ? getx() : getx() + getw(), gety(), force);
        get_unit_list()->push_back(bul);
        
        if(modeclock.check()) {
            
            mode = &shooting;
            modeclock.start(4);
        }
        
        idleclock.start(25);
        
#ifndef NOSOUND
        extern SAMPLE *shoot;
        play_sample(shoot, 255, 127, 1000, 0);
#endif
    }
    
    if(idleclock.check()) {
        
        if(mode == &idle)
            mode = &stand;
        else
            mode = &idle;
        
        leftface = rand()%2;
        
        idleclock.start(25);
    }
    
    if(!setpos(x, y)) {
        
        setpos(x, oy);
        setpos(ox, y);
        
        if(gety() != y)
            onground = true;
    }
    
    if(tileengine::tilemap::get_collision_layer()->intercepts(getx(), gety(), getx() + getw(), gety() + geth(), tileengine::spike)) {
        
        hurt();
    }
    
    return normal;
}

void player::draw(BITMAP *dest, int x, int y)
{
    if(mode == &death && modeclock.check())
        return;
    
    if(!tileengine::tilemap::get_collision_layer()->intercepts(getx() + getw() / 2, gety() + geth(), getx() + getw() / 2, gety() + geth())) {
        
        if(mode != &death)
            mode = jumpfactor > 1 ? &jumpup : (jumpfactor < -1 ? &jumpdown : &jumpapex);
    }
    
    int sy = gety() + geth();
    
    while(!tileengine::tilemap::get_collision_layer()->intercepts(getx(), sy, getx() + 15, sy + 5)) sy++;
    
    draw_sprite(dest, (BITMAP*)((DATAFILE*)dat[DAT_OBJECT].dat)[DAT_OBJECT_SHADOW0].dat, x, sy);
    
    if(!hearts || (clock.check() || (clock.seconds() / 10) % 2)) {
        
        (!leftface ? draw_sprite : draw_sprite_h_flip)(dest, mode->get_bmp(), x, y);
    }
}

void player::hurt()
{
    if(!clock.check() || hearts <= 0)
        return;
    
    hearts--;
    
    if(modeclock.check()) {
        
        mode = &die;
        modeclock.start(4);
    }
    
    if(!hearts) {
        
        mode = &death;
        modeclock.start(5);
        
        dumbo_load("songs/playerdead.it");
    }
    
#ifndef NOSOUND
    extern SAMPLE *playerdead;
    play_sample(playerdead, 255, 127, 1000, 0);
#endif
    
    clock.start(15);
}

static player *plr = 0;

void player::set_player(player *p)
{
    plr = p;
}

player *player::get_player()
{
    return plr;
}
