#include "dumbo.h"

#ifdef __cplusplus
   extern "C" {
#endif

struct {
  DUH *d;
  AL_DUH_PLAYER *p;
  unsigned char state;
} dumbo_song;

void dumbo_init(void) { 
  dumb_register_stdfiles(); 
  dumbo_song.d=NULL;
  dumbo_song.p=NULL;
  dumbo_song.state=dumbo_stopped;
}

void dumbo_exit(void) { 
  dumbo_unload();
  dumb_exit();
}

int dumbo_load(char *name) {  
  DUH *tmp=NULL;
  dumbo_unload();
  if (!name) return 0;
  tmp=dumb_load_it_quick(name);
  if (!tmp) return 0;
  else {
    dumbo_song.d=tmp;
    dumbo_play_song();
    return 1;
  }
  return 0;
}

void dumbo_unload(void) {
  dumbo_stop_song();
  if (dumbo_song.d) unload_duh(dumbo_song.d);
  dumbo_song.d=NULL;
}

void dumbo_play_song(void) {
  if (!dumbo_song.d) return;
  if (dumbo_song.state&dumbo_paused) {
    dumbo_pause_song();
  }
  else if (dumbo_song.state==dumbo_stopped) {
    dumbo_song.p=al_start_duh(dumbo_song.d, 2, 0, 1.0, 16192, 44100);
    dumbo_song.state=dumbo_playing;
  }
}

void dumbo_pause_song(void) {
  if (!dumbo_song.d) return;     
  if (dumbo_song.state&dumbo_paused) {
    al_resume_duh(dumbo_song.p);
    dumbo_song.state=dumbo_playing;
  }
  else if (dumbo_song.state&dumbo_playing) {
    al_pause_duh(dumbo_song.p);
    dumbo_song.state=dumbo_paused;
  }
}

void dumbo_stop_song(void) {
  if (!dumbo_song.d) return;
  if (dumbo_song.state&(dumbo_playing|dumbo_paused)) {
    al_stop_duh(dumbo_song.p);
  }
  dumbo_song.state=dumbo_stopped;
}

void dumbo_poll(void) {
  if (!dumbo_song.d) return;     
  if (dumbo_song.state==dumbo_playing) {
    al_poll_duh(dumbo_song.p);
  }     
}

#ifdef __cplusplus
   }
#endif
