#include "devil.h"
#include "datafile.h"
#include "bullet.h"
#include "player.h"
#include "tile.h"
using namespace std;

static const int midle = 0;
static const int mslowleft = 1;
static const int mslowright = 2;
static const int mattack = 3;

devil::devil(int level_)
    : walk("OBJECT/DEVIL/WALK"),
      stand("OBJECT/DEVIL/STAND"),
      idle("OBJECT/DEVIL/IDLE"),
      shooting("OBJECT/DEVIL/SHOOTING"),
      die("OBJECT/DEVIL/DIE"),
      death("OBJECT/DEVIL/DEATH"),
      jumpup("OBJECT/DEVIL/JUMPUP"),
      jumpapex("OBJECT/DEVIL/JUMPAPEX"),
      jumpdown("OBJECT/DEVIL/JUMPDOWN"),
      onground(0), jumpfactor(0), leftface(0), dead(0), aimode(midle), level(level_)
{
    setw(walk.get_bmp()->w);
    seth(walk.get_bmp()->h);
    setpos(700, SCREEN_H - geth(), closest);
    
    jumpthreshold = 30 * level + (rand()%75);
}

devil::~devil()
{
    extern bool shuttingdown;
    
    if(shuttingdown)
        return;
    
#ifndef NOSOUND
    extern SAMPLE *death;
    play_sample(death, 255, 127, 1000, 0);
#endif
}

int devil::think()
{
    if(dead)
        return clock.check() ? kill : normal;
    
    int x = getx(), y = gety();
    int ox = x, oy = y;
    
    player &plr = *player::get_player();
    
    if(clock.check()) {
        
        aimode = midle;
        idleleft = rand()%2;
        
        if(abs(getx() - player::get_player()->getx()) < 60 * level
            && abs(gety() - player::get_player()->gety()) < 75 * level
            && player::get_player()->hearts > 0) {
            
            aimode = mattack;
            
            clock.start(110);
        }
        
        else if(aimode != mattack){
            
            switch((rand() % 500) / 100) {
                case 0:
                    aimode = midle;
                    break;
                case 1:
                case 2:
                    aimode = mslowleft;
                    break;
                case 3:
                case 4:
                    aimode = mslowright;
                    break;
            }
            
            clock.start(rand()%10);
        }
    }
    
    jumpfactor -= .5;
    y -= (int)jumpfactor;
    
    if(aimode == mslowleft && clock.seconds() < 2)
        x -= 1;
    
    if(aimode == mslowright && clock.seconds() < 2)
        x += 1;
    
    if(aimode == mattack) {
        
        if(gunclock.check() && abs(plr.gety() - gety()) < 10 + (rand()%50)) {
            
            bullet *bul = new bullet(this, plr.getx() < getx());
            bul->setpos(getx() + (plr.getx() < getx() ? 0 : getw()), gety());
            get_unit_list()->push_back(bul);
            
#ifndef NOSOUND
            extern SAMPLE *shoot;
            play_sample(shoot, 255, 127, 1000, 0);
#endif
            
            gunclock.start(rand()%60);
        }
        
        if(plr.hearts) {
            
            if(plr.getx() < getx() && rand()%10)
                x -= level + (rand()%500) ? 1 : 0;
            
            if(plr.getx() > getx() && rand()%10)
                x += level + (rand()%500) ? 1 : 0;
            
            if(plr.gety() < gety() - jumpthreshold && onground && (abs(plr.getx() - getx()) < 30 || abs(plr.getx() - getx()) > 100 + (rand()%200))) {
                
                jumpfactor = 12;
                
#ifndef NOSOUND
                extern SAMPLE *jump;
                play_sample(jump, 255, 127, 1000, 0);
#endif
            }
        }
    }
    
    moved = x != getx();
    
    if(!setpos(x, y)) {
        
        setpos(x, oy);
        setpos(ox, y);
    }
    
    onground = gety() == oy;
    
    if(onground && jumpfactor < -1)
        jumpfactor = 0;
    
    if(onground && oy != y)
        setpos(x, oy);
    
    return normal;
}

void devil::draw(BITMAP *dest, int x, int y)
{
    BITMAP *bmp;
    
    player &plr = *player::get_player();
    
    if(dead) {
        
        bmp = death.get_bmp();
        
        (idleleft ? draw_sprite : draw_sprite_h_flip)(dest, bmp, x, y);
    }
    
    else if(!tileengine::tilemap::get_collision_layer()->intercepts(getx() + getw() / 2, gety() + geth(), getx() + getw() / 2, gety() + geth())) {
        
        draw_sprite(dest, (jumpfactor > 1 ? jumpup : (jumpfactor < -1 ? jumpdown : jumpapex)).get_bmp(), x, y);
    }
    
    else if(gunclock.seconds() < 4 && aimode == mattack) {
        
        bmp = shooting.get_bmp();
        
        (plr.getx() > getx() ? draw_sprite : draw_sprite_h_flip)(dest, bmp, x, y);
    }
    
    else if(aimode == mattack) {
        
        bmp = walk.get_bmp();
        
        (plr.getx() > getx()? draw_sprite : draw_sprite_h_flip)(dest, bmp, x, y);
    }
    
    else if(moved) {
        
        bmp = walk.get_bmp();
        
        (aimode == mslowright ? draw_sprite : draw_sprite_h_flip)(dest, bmp, x, y);
    }
    
    else if(aimode == midle) {
        
        bmp = idle.get_bmp();
        
        (idleleft ? draw_sprite : draw_sprite_h_flip)(dest, bmp, x, y);
    }
    
    else {
        
        bmp = stand.get_bmp();
        
        (idleleft ? draw_sprite : draw_sprite_h_flip)(dest, bmp, x, y);
    }
}

void devil::oncollide(unit *u)
{
    player *plr = dynamic_cast<player*>(u);
    
    if(plr && !dead)
        plr->hurt();
}

void devil::murder()
{
    dead = true;
    
    clock.start(10);
}

bool devil::alive()
{
    return !dead;
}
