#ifndef _conf_included_conf_h
#define _conf_included_conf_h

#include <string>
#include <sstream>
#include <exception>
#include <allegro.h>

#define _conf_etype(Ty) \
    typedef struct Ty : public error { \
        Ty(const std::string e) : error(e) {} \
        Ty(std::exception e) : error(e) {} \
    } Ty;
    
extern class conf {
public:
    
    class error : public std::exception {
        private:
            std::string error_s;
        
        public:
            error(const std::string &e) throw() : error_s(e) {}
            error(const std::exception &e) throw() : error_s(e.what()) {}
            
            virtual ~error() throw() {}
            
            virtual const char *what() const throw() {
                try {
                    return error_s.c_str();
                } catch (...) {
                    return "std::string error.  Exception information lost.";
                }
            }
    };
    
    _conf_etype(MultipleConfInstancesError)
    _conf_etype(GraphicsCaptureError)
    _conf_etype(PageFlippingError)
    _conf_etype(GraphicsFailure)
	
	static BITMAP *screen;
	static bool ready;
    
    static const int raw           = 1;
    static const int double_buffer = 2;
    static const int page_flip     = 4;
    
    bool stretch_mode;

private:
    BITMAP *buffer;
    BITMAP *page1;
    BITMAP *page2;

    struct def {
#ifdef DEBUGMODE
        static const int mode        = GFX_AUTODETECT_WINDOWED;
#else
        static const int mode        = GFX_AUTODETECT_FULLSCREEN;
#endif
        static const int w           = 320;
        static const int h           = 200;
        static const int update_mode = raw | double_buffer;
    };
    
    // These variables used to revert from failured modes
    int mode;
    int screen_w, screen_h;
    
    int set_gfx_mode(int,int,int);
    
    bool init_page_flipping();
    bool init_double_buffer();
    
public:
    conf();

    const char *get_mode();

    void init(int mode = def::mode, int w = def::w, int h = def::h, int update_mode = def::update_mode);
    void shutdown();
    
    void post_draw();
} config;

#endif
