#include "conf.h"
#include <string>
using namespace std;

BITMAP *conf::screen = 0;
bool conf::ready = false;

static int instance_count = 0;
conf config;

conf::conf() : stretch_mode(0), buffer(0), page1(0),
    page2(0), mode(def::mode),
    screen_w(def::w), screen_h(def::h) {
    
	if(instance_count++)
		throw MultipleConfInstancesError("Multiple conf instances!");
}

int conf::set_gfx_mode(int mode, int w, int h) {
    
	int ret = ::set_gfx_mode(mode, w, h, 0, 0);
	
	if(ret == 0) {
		screen = ::screen;
		this->mode = mode;
		screen_w = SCREEN_W;
		screen_h = SCREEN_H;
		
        if(screen)
            clear_to_color(screen, makecol(0, 0, 0));
	}
	
    ready = ret == 0;
    
	return ret;
}

bool conf::init_page_flipping() {
    
	destroy_bitmap(page1);
	destroy_bitmap(page2);
	
	page1 = 0;
	page2 = 0;
	
	if(gfx_driver && !(gfx_capabilities & GFX_CAN_TRIPLE_BUFFER))
		enable_triple_buffer();
	
	if(gfx_capabilities & GFX_CAN_SCROLL) {
        
		if((page1 = create_video_bitmap(screen_w, screen_h))) {
            
			if((page2 = create_video_bitmap(screen_w, screen_h))) {
                
				screen = page1;
				
				clear_to_color(page1, makecol(0, 0, 0));
				clear_to_color(page2, makecol(0, 0, 0));
			} else {
                
				destroy_bitmap(page1);
				page1 = 0;
			}
		}
	}
	
	return page1 && page2;
}

bool conf::init_double_buffer() {
    
	destroy_bitmap(buffer);
	
	if((buffer = create_bitmap(screen_w, screen_h))) {
        
		screen = buffer;
		
		clear_to_color(buffer, makecol(0, 0, 0));
	}
	
	return buffer;
}

const char *conf::get_mode() {
    
	if(page1 && page2)
		return "Using mode 'Page Flipping'";
    
	else if(buffer)
		return "Using mode 'Double Buffer'";
    
	else
		return "Using mode 'Direct Drawing'";
}

void conf::init(int mode, int w, int h, int update_mode) {
    
    shutdown();
    
    tryagain:;
    
    if(0 != set_gfx_mode(mode, w, h)) {
		
        if(0 != set_gfx_mode(this->mode, screen_w, screen_h)) {
            
            if(stretch_mode)
                throw GraphicsFailure("No suitable graphics mode found.");
            else {
                
                stretch_mode = 1;
                w = 640, h = 480;
                goto tryagain;
            }
        }
    }
	
    if(mode != GFX_TEXT) {
        
        if(update_mode & page_flip)
            if(init_page_flipping())
                return;
        
        if(update_mode & double_buffer)
            if(init_double_buffer())
                return;
    }
    
    if(!(update_mode & raw))
        throw GraphicsFailure("No suitable update mode found.");
}

void conf::shutdown() {
    
	destroy_bitmap(buffer);
	destroy_bitmap(page1);
	destroy_bitmap(page2);
    
    buffer = page1 = page2 = 0;
}

void conf::post_draw() {
    
    if(0 == screen)
        return;
    
	if(screen == buffer && buffer) {
        
		stretch_blit(buffer, ::screen, 0, 0, 320, 200, 0, 0, screen_w, screen_h);
        
	} else if(screen == page1 && page1) {
        
		if(gfx_capabilities & GFX_CAN_TRIPLE_BUFFER) {
            
			while(poll_scroll())
				;
			
			if(request_video_bitmap(page1) != 0)
				throw PageFlippingError("request_video_bitmap() failed.");
		} else
        
			if(show_video_bitmap(page1) != 0)
				throw PageFlippingError("show_video_bitmap() failed.");
		
		screen = page2;
            
	} else if(screen == page2 && page2) {
        
		if(gfx_capabilities & GFX_CAN_TRIPLE_BUFFER) {
            
			while(poll_scroll())
				;
			
			if(request_video_bitmap(page2) != 0)
				throw PageFlippingError("request_video_bitmap() failed.");
		} else
        
			if(show_video_bitmap(page2) != 0)
				throw PageFlippingError("show_video_bitmap() failed.");
		
		screen = page1;
	}
}
