#include "bullet.h"
#include "devil.h"
#include "boss.h"
#include "particle.h"
#include "datafile.h"
#include "tile.h"
#include "player.h"
using namespace std;

bullet::bullet(unit *assassin_, bool left_) : angle_projectile("OBJECT/ANGEL/PROJECTILE/"), devil_projectile("OBJECT/DEVIL/PROJECTILE"), left(left_), assassin(assassin_)
{
    deathclock.start(35);
    
    setw(devil_projectile.get_bmp()->w);
    seth(devil_projectile.get_bmp()->h);
    
    demonspawn = !dynamic_cast<player*>(assassin);
}

bullet::~bullet()
{
    extern bool shuttingdown;
    
    if(shuttingdown)
        return;
      
#ifndef NOSOUND
    extern SAMPLE *thud;
    play_sample(thud, 255, 127, 1000, 0);
#endif
    
    int n = rand()%30;
    
    for(int i = 0; i < n; i++)
        particle_manager::get_particle_manager()->add(getx() + getw() / 2, gety() + geth() / 2, 2, ((double)(rand()%3000)/3000) * 6.28318531, .2);
    
    n = rand()%30;
    
    for(int i = 0; i < n; i++)
        particle_manager::get_particle_manager()->add(getx() + getw() / 2, gety() + geth() / 2, 1, ((double)(rand()%3000)/3000) * 6.28318531, .8);
    
    n = rand()%30;
    
    for(int i = 0; i < n; i++)
        particle_manager::get_particle_manager()->add(getx() + getw() / 2, gety() + geth() / 2, 1, ((double)(rand()%3000)/3000) * 6.28318531, 1.2);
    
    n = rand()%10;
    
    for(int i = 0; i < n; i++)
        particle_manager::get_particle_manager()->add(getx() + getw() / 2, gety() + geth() / 2, 1, ((double)(rand()%3000)/3000) * 6.28318531, 2);
}

int bullet::think()
{
    left ? setpos(getx() - 4, gety(), force) : setpos(getx() + 4, gety(), force);
    
    if(tileengine::tilemap::get_collision_layer()->intercepts(getx(), gety(), getx() + getw(), gety() + geth()))
        deathclock.start(0);
    
    particle_manager::get_particle_manager()->add(!left ? getx() : getx() + getw(), gety() + (rand()%geth()), 1);
    
    return deathclock.check() ? kill : normal;
}

void bullet::draw(BITMAP *dest, int x, int y)
{
    BITMAP *bmp = !demonspawn ? angle_projectile.get_bmp() : devil_projectile.get_bmp();
    
    if(bmp)
        (left ? draw_sprite : draw_sprite_h_flip)(dest, bmp, x, y);
}

void bullet::oncollide(unit *plr)
{
    player *target;
    devil *dtarg;
    boss *ufo;
    
    if(demonspawn && (target = dynamic_cast<player*>(plr)))
        target->hurt();
    
    else if(!demonspawn && (dtarg = dynamic_cast<devil*>(plr))) {
        
        if(!dtarg->alive())
            return;
        
        dtarg->murder();
    }
    
    else if(!demonspawn && (ufo = dynamic_cast<boss*>(plr)))
        ufo->hurt();
    
    else
        return;
    
    deathclock.start(0);
}
