#include "bomb.h"
#include "player.h"
#include "particle.h"
using namespace std;

bomb::bomb(int x, int y)
    : anim("OBJECT/BOSS/BOMB"), fallspeed(.4), dead(0)
{
    setpos(x, y, closest);
    setw(anim.get_bmp()->w);
    seth(anim.get_bmp()->h);
}

bomb::~bomb()
{
    extern bool shuttingdown;
    
    if(shuttingdown)
        return;
    
#ifndef NOSOUND
    extern SAMPLE *thud;
    play_sample(thud, 255, 127, 1000, 0);
#endif
    
    int n = rand()%30;
    
    for(int i = 0; i < n; i++)
        particle_manager::get_particle_manager()->add(getx() + getw() / 2, gety() + geth() / 2, 2, ((double)(rand()%3000)/3000) * 6.28318531, .2);
    
    n = rand()%30;
    
    for(int i = 0; i < n; i++)
        particle_manager::get_particle_manager()->add(getx() + getw() / 2, gety() + geth() / 2, 1, ((double)(rand()%3000)/3000) * 6.28318531, .8);
    
    n = rand()%30;
    
    for(int i = 0; i < n; i++)
        particle_manager::get_particle_manager()->add(getx() + getw() / 2, gety() + geth() / 2, 1, ((double)(rand()%3000)/3000) * 6.28318531, 1.2);
    
    n = rand()%10;
    
    for(int i = 0; i < n; i++)
        particle_manager::get_particle_manager()->add(getx() + getw() / 2, gety() + geth() / 2, 1, ((double)(rand()%3000)/3000) * 6.28318531, 2);
}

int bomb::think()
{
    fallspeed += .1;
    
    if(!(rand()%3))
        particle_manager::get_particle_manager()->add(getx() + (rand() % (getw() / 2)), gety() + (rand()%geth()), 2);
    
    if(dead || !setpos(getx(), gety() + (int)fallspeed))
        return kill;
    
    return normal;
}

void bomb::draw(BITMAP *dest, int x, int y)
{
    draw_sprite(dest, anim.get_bmp(), x, y);
}

void bomb::oncollide(unit *u)
{
    player *plr = dynamic_cast<player*>(u);
    
    if(plr && plr->hearts > 0)
        dead = true, plr->hurt();
}
