#ifndef TILE_H
#define TILE_H

#include <vector>
#include <list>
#include <string>
#include <allegro.h>

namespace tileengine {

    static const int solid = 1;
    static const int spike = 2;

    class tile {
        
    public:
        
        BITMAP *bmp;
        int flags;
        
        tile(BITMAP*, int);
    };
    
    tile tile_factory(const std::string &name, int flags = 0);
    
    class cloud {
        
    public:
        
        int x, y, speed, width;
        int flip;
        bool leftface;
        BITMAP *bmp;
        
        cloud(int width, bool menu = false);
        
        void draw(BITMAP*, int xscroll);
        void process();
        bool done();
    };
    
    class tilemap {
        
        std::vector<tile> hills;
        std::vector<tile> tiles;
        std::list<cloud> clouds;
        
        int cloud_density;
        BITMAP *sun;
        
        // Constructed starting top left, going down for ceil(SCREEN_H / 32) frames,
        // then string again at the next row to the right
        
    public:
        
        void generate(int seed = time(0));
        
        void draw(BITMAP*, int xscroll);
        bool intercepts(int x1, int y1, int x2, int y2, int flags = solid);
        
        static void set_collision_layer(tilemap*);
        static tilemap *get_collision_layer();
        
        int getw();
        int geth();
    };
}

#endif
