#include "stopwatch.h"
using namespace std;

volatile unsigned int *stopwatch::tickptr = 0;
double stopwatch::second_factor = 1;

stopwatch::stopwatch()
    : start_time(0), ticking(0)
{

}

void stopwatch::start(unsigned int time)
{
    start_time = *tickptr;
    ticking = true;
    pause_time = (unsigned int)(time * second_factor);
}

bool stopwatch::check()
{
    if(!ticking || (*tickptr - start_time) >= pause_time) {
        
        ticking = false;
        return true;
    }
    
    return false;
}

unsigned int stopwatch::seconds()
{
    if(ticking)
        return (unsigned int)((*tickptr - start_time));
    
    return 0;
}
