#ifndef PARTICLE_H
#define PARTICLE_H

#include <list>
#include "animation.h"
#include "unit.h"
#include "stopwatch.h"

class particle_manager : public unit {
    
    struct particle {
        
        animation anim;
        double x, y;
        double direction, speed;
        stopwatch lifetimer;
        
    public:
        
        particle(int x, int y, int type, double direction, double speed);
        
        int think();
        void draw(BITMAP*, int xscroll);
    };
    
    std::list<particle*> particles;
    
public:
    
    particle_manager();
    ~particle_manager();
    
    void add(int x, int y, int type, double direction = 0, double speed = 0);
    
    virtual int think();
    virtual void draw(BITMAP*, int xscroll, int);
    
    static void set_particle_manager(particle_manager*);
    static particle_manager *get_particle_manager();
};

#endif
