#include "particle.h"
#include "tile.h"
#include <iostream>
#include <cmath>
using namespace std;

particle_manager::particle::particle(int x_, int y_, int type, double dir, double spd)
    : anim(type == 1 ? "OBJECT/PARTICLE" : "OBJECT/FIREWORK"),
      x(x_), y(y_), direction(dir), speed(spd)
{
    lifetimer.start(type == 1 ? rand()%20 : 3);
}

int particle_manager::particle::think()
{
    //BITMAP *bmp = anim.get_bmp();
    
    x += cos(direction) * speed;
    y -= sin(direction) * speed;
    
    return lifetimer.check() ? -1 : 0;
}

void particle_manager::particle::draw(BITMAP *dest, int xscroll)
{
    BITMAP *bmp = anim.get_bmp();
    
    draw_sprite(dest, bmp, (int)(x + xscroll) - bmp->w / 2, (int)y - bmp->h / 2);
}

particle_manager::particle_manager()
{
    setpos(0, 0, force);
    setw(0);
    seth(0);
}

particle_manager::~particle_manager()
{
    for(list<particle*>::iterator itr = particles.begin(); itr != particles.end(); ++itr) {
        
        delete *itr;
    }
}

void particle_manager::add(int x, int y, int type, double direction, double speed)
{
    particles.push_back(new particle(x, y, type, direction, speed));
}

int particle_manager::think()
{
    for(list<particle*>::iterator itr = particles.begin(); itr != particles.end(); ) {
        
        if((*itr)->think() == -1) {
            
            delete *itr;
            itr = particles.erase(itr);
        }
        else
            ++itr;
    }
    
    return normal;
}

void particle_manager::draw(BITMAP *dest, int xscroll, int)
{
    for(list<particle*>::iterator itr = particles.begin(); itr != particles.end(); ++itr) {
        
        (*itr)->draw(dest, xscroll);
    }
}

particle_manager *manager = 0;

void particle_manager::set_particle_manager(particle_manager *pm)
{
    manager = pm;
}

particle_manager * particle_manager::get_particle_manager()
{
    return manager;
}
