#include "player.h"
#include "tile.h"
#include "boss.h"
#include "datafile.h"
#include "particle.h"
#include "devil.h"
#include "conf.h"
#include "dumbo.h"
#include "animation.h"
#include "stopwatch.h"
#include <string>
#include <list>
#include <allegro.h>
#include <cmath>
#include <iostream>
using namespace std;
using namespace tileengine;

extern unsigned int frames;
extern volatile unsigned int total_ticks;
extern volatile unsigned int tick_debt;
extern volatile unsigned int msecs;
const int running_bps = 60;
void ticker();

void reset()
{
    frames = total_ticks = tick_debt = msecs = 0;
}

int leftkey = KEY_LEFT;
int rightkey = KEY_RIGHT;
int jumpkey = KEY_UP;
int firekey = KEY_RCONTROL;

int get_scancode()
{
    if(keypressed())
        return readkey() >> 8;
    
    #define CHECK_KEY(scancode) \
        if(key[scancode]) return scancode
    
    CHECK_KEY(KEY_RSHIFT);
    CHECK_KEY(KEY_LSHIFT);
    CHECK_KEY(KEY_RCONTROL);
    CHECK_KEY(KEY_LCONTROL);
    CHECK_KEY(KEY_ALT);
    CHECK_KEY(KEY_ALTGR);
    CHECK_KEY(KEY_LWIN);
    CHECK_KEY(KEY_RWIN);
    CHECK_KEY(KEY_MENU);
    CHECK_KEY(KEY_SCRLOCK);
    CHECK_KEY(KEY_NUMLOCK);
    CHECK_KEY(KEY_CAPSLOCK);
    CHECK_KEY(KEY_ENTER);
    
    return 0;
}

bool sure(const string &ofwhat);
void story(int stage);
void world_map(int level);

bool inmenu = 0;

int mainmenu()
{
    if(!inmenu) {
        
        dumbo_load("songs/title.it");
        inmenu = 1;
    }
    
    list<cloud> clouds;
    
    reset();
    install_int_ex(ticker, BPS_TO_TIMER(50));
    
    for(int i = 0; i < 1000; i++) {
        
        if(!(rand()%50))
            clouds.push_back(cloud(320, true));
        
        for(list<cloud>::iterator itr = clouds.begin(); itr != clouds.end(); ) {
            
            itr->process();
            
            if(itr->done())
                itr = clouds.erase(itr);
            else
                ++itr;
        }
    }
    
    while(!keypressed()) {
        
        dumbo_poll();
        
        if(tick_debt) {
            
            tick_debt--;
            
            clear_to_color(config.screen, makecol(222, 222, 222));
            
            for(list<cloud>::iterator itr = clouds.begin(); itr != clouds.end(); ) {
                
                itr->draw(config.screen, 0);
                itr->process();
                
                if(itr->done())
                    itr = clouds.erase(itr);
                else
                    ++itr;
            }
            
            draw_sprite(config.screen, (BITMAP*)dat[DAT_TITLE].dat, 17, 10);
            
            config.post_draw();
            
            if(!(rand()%50))
                clouds.push_back(cloud(320, true));
        }
    }
    
    while(key[KEY_ENTER] || key[KEY_SPACE] || key[KEY_TAB] || key[KEY_ESC]);
    
    clear_keybuf();
    
    clear_to_color(config.screen, makecol(222, 222, 222));
    config.post_draw();
    
    return 2;
}

bool shuttingdown = false;

int maingame()
{
    inmenu = 0;
    
    bool quit = false;
    
    for(int level = 1; level <= 3 && !quit; level++) {
        
        world_map(level);
        
        tilemap map;
        tilemap::set_collision_layer(&map);
        
        map.generate();
        
        list<unit*> units;
        unit::set_unit_list(&units);
        
        particle_manager &particles = *(new particle_manager);
        particle_manager::set_particle_manager(&particles);
        units.push_back(&particles);
        
        player &plr = *(new player);
        units.push_back(&plr);
        player::set_player(&plr);
        
        boss *ufo = 0;
        
        if(level == 3) {
            
            ufo = new boss;
            units.push_back(ufo);
        }
        
        plr.left = leftkey;
        plr.right = rightkey;
        plr.jump = jumpkey;
        plr.fire = firekey;
        
        int xscroll = 0;
        bool draw = false;
        
        for(int i = 0; i < 20 * level; i++) {
            
            devil *baddie = new devil(level);
            baddie->setpos(800 + (rand()%(map.getw() - 800)), 10 + (rand()%100), unit::closest);
            units.push_back(baddie);
        }
        
        int cluster1x = 1000 + (rand()%(map.getw() - 1000));
        int cluster2x = (map.getw() - 500) + (rand()%(500));
        
        for(int i = 0; i < 2 * level; i++) {
            
            devil *baddie = new devil(level);
            baddie->setpos(cluster1x + ((rand()%100) - 50), 10 + (rand()%100), unit::closest);
            units.push_back(baddie);
        }
        
        for(int i = 0; i < 5 * level; i++) {
            
            devil *baddie = new devil(level);
            baddie->setpos(cluster2x + ((rand()%100) - 50), 10 + (rand()%100), unit::closest);
            units.push_back(baddie);
        }
        
        dumbo_load("songs/stage.it");
        
        reset();
        install_int_ex(ticker, BPS_TO_TIMER(running_bps));
        
        bool levelbeat = false;
        unsigned int whenbeat = 0;
        bool rightfirework = false;
        bool leftfirework = false;
        
        bool bossalive = true;
        
        while(!quit && !(levelbeat && total_ticks - whenbeat > 300 && keypressed())) {
        
            dumbo_poll();
            
            if(levelbeat && total_ticks - whenbeat > 200)
                clear_keybuf();
            
            if(!levelbeat && !plr.hearts && (key[KEY_ENTER] || key[KEY_SPACE] || key[KEY_TAB] || key[KEY_ESC])) {
                
                quit = true;
                break;
            }
            
            if(key[KEY_ESC] && sure("quit"))
                return 2;
            
            while(tick_debt) {
                
                tick_debt--;
                draw = true;
                
                while(plr.getx() < (320 / 3) + xscroll)
                    xscroll--;
                
                while(plr.getx() + plr.getw() >= 2 * 320 / 3 + xscroll)
                    xscroll++;
                
                xscroll = MAX(xscroll, 0);
                xscroll = MIN(xscroll, map.getw() - 320);
                
                for(list<unit*>::iterator itr = units.begin(); itr != units.end(); ) {
                    
                    if(levelbeat && dynamic_cast<devil*>(*itr))
                        dynamic_cast<devil*>(*itr)->murder();
                    
                    if((*itr)->think() == unit::kill || (levelbeat && total_ticks - whenbeat > 60 && dynamic_cast<devil*>(*itr))) {
                        
                        if(dynamic_cast<boss*>(*itr))
                            bossalive = false;
                        
                        delete *itr;
                        itr = units.erase(itr);
                    }
                    else
                        ++itr;
                }
                
                if(!bossalive || (level != 3 && !levelbeat && plr.getx() > map.getw() - 64 && plr.getx() < map.getw() - 32 && plr.gety() > 64 && plr.gety() < 96)) {
                    
                    plr.hearts = 0;
                    bossalive = true;
                    
                    levelbeat = true;
                    whenbeat = total_ticks;
                    
                    dumbo_load("songs/levelcomplete.it");
                }
                
                if(levelbeat && total_ticks - whenbeat < 10) {
                    
                    for(int i = 0; i < 25; i++)
                        particles.add(xscroll + (320 / 2 - 100) + i * 8, 200 / 2 - 25, 1, 1, 1.4);
                }
                
                if(levelbeat && total_ticks - whenbeat > 8 && !rightfirework) {
                    
                    rightfirework = true;
                    
                    for(int i = 0; i < 25; i++)
                        particles.add(xscroll + (320 / 2 - 75) + i * 8, 200 / 2 - 50, 2, 1, 0);
                }
                
                if(levelbeat && total_ticks - whenbeat >= 10 && total_ticks - whenbeat < 20) {
                    
                    for(int i = 0; i < 25; i++)
                        particles.add(xscroll + (320 / 2 + 100) + i * 8, 200 / 2 - 25, 1, 2.14159265, 1.4);
                }
                
                if(levelbeat && total_ticks - whenbeat > 18 && !rightfirework) {
                    
                    rightfirework = true;
                    
                    for(int i = 0; i < 25; i++)
                        particles.add(xscroll + (320 / 2 + 75) + i * 8, 200 / 2 - 50, 2, 1, 0);
                }
                
                if(levelbeat && total_ticks - whenbeat > 20 && total_ticks - whenbeat < 200) {
                    
                    particles.add(xscroll + (320 / 2 - 100) + (rand()%200), (200 / 2 - 25) + (rand()%50), 2, 0, 0);
                }
                
                if(levelbeat && total_ticks - whenbeat > 100) {
                    
                    particles.add(xscroll + (320 / 2 - 100) + (rand()%200), (200 / 2 - 25) + (rand()%50), 1, 1, 2.14159265);
                }
            }
            
            if(draw) {
                
                clear_to_color(config.screen, makecol(222, 222, 222));
                
                map.draw(config.screen, xscroll);
                
                for(list<unit*>::iterator itr = units.begin(); itr != units.end(); ++itr) {
                    
                    if(!levelbeat || !dynamic_cast<player*>(*itr))
                        (*itr)->draw(config.screen, (*itr)->getx() - xscroll, (*itr)->gety());
                }
                
                BITMAP *bmp;
                
                for(int i = 0; i < 5; i++) {
                    
                    bmp = (BITMAP*)dat[(i < plr.hearts) ? DAT_HEARTFULL : DAT_HEARTEMPTY].dat;
                    
                    draw_sprite(config.screen, bmp, 15 + i * (bmp->w + 10), 15);
                }
                
                double mana = plr.shotclock.seconds() / 100.0;
                
                if(plr.shotclock.check())
                    mana = 1;
                
                draw_sprite(config.screen, (BITMAP*)dat[DAT_MANABAR].dat, 230, 10);
                rectfill(config.screen, 236, 13, (int)(235 + 63 * mana), 21, makecol(187, 187, 187));
                
                if(levelbeat) {
                    
                    draw_sprite(config.screen, (BITMAP*)((DATAFILE*)dat[DAT_OBJECT].dat)[DAT_OBJECT_LEVELMESSAGE].dat, 320 / 2 - 61, 200 / 2 - 12);
                }
                
                config.post_draw();
                
                frames++;
                draw = false;
            }
        }
        
        quitmaingame:;
        
        shuttingdown = true;
        
        for(list<unit*>::iterator itr = units.begin(); itr != units.end(); ++itr)
            delete *itr;
        
        shuttingdown = false;
    }
    
    while(key[KEY_ENTER] || key[KEY_SPACE] || key[KEY_TAB] || key[KEY_ESC]);
    
    clear_keybuf();
    
    return 2;
}

void draw_cursor(BITMAP *dest, int x, int y)
{
    for(int i = 0; i < 7; i++)
        circlefill(dest, x, y, 7 - i, i);
}

int keyconfig()
{
    if(!inmenu) {
        
        dumbo_load("songs/title.it");
        inmenu = 1;
    }

    list<cloud> clouds;
    int selection = 4;
    bool selecting = false;
    bool sup = key[KEY_UP], sdown = key[KEY_DOWN];
    
    while(key[KEY_ESC]);
    
    reset();
    install_int_ex(ticker, BPS_TO_TIMER(50));
    
    while(1) {
        
        dumbo_poll();
        
        if(tick_debt) {
            
            tick_debt--;
            
            clear_to_color(config.screen, makecol(222, 222, 222));
            
            for(list<cloud>::iterator itr = clouds.begin(); itr != clouds.end(); ) {
                
                itr->draw(config.screen, 0);
                itr->process();
                
                if(itr->done())
                    itr = clouds.erase(itr);
                else
                    ++itr;
            }
            
            textout_centre_ex(config.screen, font, "Keyboard Configuration", 320 / 2, 5, -1, -1);
            
            textprintf_ex(config.screen, font, 20, 40, -1, -1, "Move Left Key    %s", scancode_to_name(leftkey));
            textprintf_ex(config.screen, font, 20, 65, -1, -1, "Move Right Key   %s", scancode_to_name(rightkey));
            textprintf_ex(config.screen, font, 20, 90, -1, -1, "Jump Key       %s", scancode_to_name(jumpkey));
            textprintf_ex(config.screen, font, 20, 115, -1, -1, "Fire Magic Key   %s", scancode_to_name(firekey));
            textprintf_ex(config.screen, font, 20, 145, -1, -1, "Start Game");
            textprintf_ex(config.screen, font, 20, 170, -1, -1, "Quit");
            
            selection = selection%6;
            
            draw_cursor(config.screen, 10, text_height(font) / 2 + 40 + selection * 25 + (selection > 3 ? 5 : 0));
            
            if(key[KEY_ENTER] || key[KEY_SPACE]) {
                
                while(key[KEY_ENTER] || key[KEY_SPACE]);
                
                clear_keybuf();
                
                if(selection == 4)
                    return 1;
                if(selection == 5)
                    return -1;
                
                selecting = true;
                
#ifndef NOSOUND
                extern SAMPLE *jump;
                play_sample(jump, 255, 127, 1000, 0);
#endif
            }
        
            if(selecting) {
                
                int key = get_scancode();
                
                if(selection == 0)
                    leftkey = key;
                if(selection == 1)
                    rightkey = key;
                if(selection == 2)
                    jumpkey = key;
                if(selection == 3)
                    firekey = key;
                
                selecting = key == 0;
                
                if(!selecting) {
#ifndef NOSOUND
                    extern SAMPLE *heart;
                    play_sample(heart, 255, 127, 1000, 0);
#endif
                }
            }
            else if(key[KEY_DOWN] && !sdown)
                selection++;
            else if(key[KEY_UP] && !sup)
                selection--;
            
            sup = key[KEY_UP];
            sdown = key[KEY_DOWN];
            
            if(selection < 0)
                selection = 5;
            
            if(key[KEY_ESC])
                return -1;
        
            config.post_draw();
            
            if(!(rand()%80))
                clouds.push_back(cloud(320, true));
        }
    }
    
    clear_keybuf();
    
    return 1;
}

bool sure(const string &ofwhat)
{
    textprintf_centre_ex(config.screen, font, 320 / 2, 200 / 2 - 25, -1, -1,
        "Are you sure you want to %s?", ofwhat.c_str());
    
    textprintf_centre_ex(config.screen, font, 320 / 2, 200 / 2 + 25, -1, -1,
        "yes or no");
    
    config.post_draw();
    
    dumbo_pause_song();
    
    while(1) {
        
        dumbo_poll();
        
        if(key[KEY_Y]) {
            
            reset();
            return true;
        }
        if(key[KEY_N]) {
            
            reset();
            return false;
        }
    }
    
    dumbo_play_song();
}

void thickline(BITMAP *dest, int x, int y, int col)
{
    circlefill(dest, x, y, 1, col);
}

void world_map(int level)
{
    inmenu = 0;
    
    BITMAP *map = (BITMAP*)dat[DAT_MAP].dat;
    BITMAP *levelb = (BITMAP*)dat[DAT_LEVEL].dat;
    BITMAP *levelcomplete = (BITMAP*)dat[DAT_LEVELCOMPLETE].dat;
    BITMAP *arrow = (BITMAP*)dat[DAT_ARROW].dat;
    
    dumbo_load("songs/worldmap.it");
    
    reset();
    install_int_ex(ticker, BPS_TO_TIMER(5));
    
    clear_keybuf();
    
    bool arrowdirection = 1;
    int arrowx, arrowy, sarrowy;
    
    if(level == 1)
        arrowx = 38, sarrowy = arrowy = 19;
    else if(level == 2)
        arrowx = 160, sarrowy = arrowy = 106;
    else 
        arrowx = 265, sarrowy = arrowy = 30;
    
    while((!keypressed() || total_ticks < 15) && total_ticks < 5 * 15) {
        
        dumbo_poll();
        
        if(tick_debt) {
            
            tick_debt--;
            
            if(arrowdirection) {
                
                arrowy += (int)ceil(((sarrowy + 20) - arrowy) / 8.0);
                
                if(arrowy >= sarrowy + 10)
                    arrowdirection = 0;
            }
            else {
                
                arrowy -= (int)ceil(((arrowy + 10) - sarrowy) / 8.0);
                
                if(arrowy <= sarrowy)
                    arrowdirection = 1;
            }
            
            draw_sprite(config.screen, map, 0, 0);
            
            if(level > 1) {
                
                do_line(config.screen, 49, 64, 170, 151, makecol(187, 187, 187), thickline);
                draw_sprite(config.screen, levelcomplete, 41, 56 - 14);
            }
            else
                draw_sprite(config.screen, levelb, 41, 56);
            
            if(level > 2) {
                
                do_line(config.screen, 170, 151, 276, 85, makecol(187, 187, 187), thickline);
                draw_sprite(config.screen, levelcomplete, 162, 143 - 14);
            }
            else
                draw_sprite(config.screen, levelb, 162, 143);
            
            if(level > 3)
                draw_sprite(config.screen, levelcomplete, 268, 77 - 14);
            else
                draw_sprite(config.screen, levelb, 268, 77);
            
            draw_sprite(config.screen, arrow, arrowx, arrowy);
            
            config.post_draw();
        }
    }
}

void story(int stage)
{
    char *message;
    
    if(stage == 1) {
        
        message = "Stage One Story";
    }
    if(stage == 2) {
        
        message = "Stage Two Story";
    }
    if(stage == 3) {
        
        message = "Stage Three Story";
    }
    if(stage == 4) {
        
        message = "Stage Four Story";
    }
    
    
}
