#include "player.h"
#include "tile.h"
#include "datafile.h"
#include "devil.h"
#include "dumbo.h"
#include "conf.h"
#include "animation.h"
#include "stopwatch.h"
#include <string>
#include <list>
using namespace std;
using namespace tileengine;

unsigned int frames = 0;
volatile unsigned int total_ticks = 0;
volatile unsigned int tick_debt = 0;
volatile unsigned int msecs = 0;
const int running_bps = 60;

SAMPLE *death;
SAMPLE *heart;
SAMPLE *jump;
SAMPLE *playerdead;
SAMPLE *shoot;
SAMPLE *thud;

void ticker()
{
    total_ticks++;
    tick_debt++;
    
    msecs += 1000 / running_bps;
}
END_OF_FUNCTION(ticker)

void errorExit(const string &problem)
{
    allegro_message("An error occured.\n%s.\n%s", problem.c_str(), allegro_error);
    
    exit(1);
}

int mainmenu();
int maingame();
int keyconfig();

int main()
{
    if(0 != allegro_init())
        errorExit("While intializing allegro");
    
    if(0 != install_keyboard())
        errorExit("While installing keyboard");
    
    if(0 != install_timer())
        errorExit("While installing timer");
    
#ifndef NOSOUND
    if(0 != install_sound(DIGI_AUTODETECT, MIDI_NONE, 0))
        errorExit("While installing sound");
    
    if(0 == (death = load_sample("sfx/death.wav")))
        errorExit("While loading sound 1");
    
    if(0 == (heart = load_sample("sfx/heart.wav")))
        errorExit("While loading sound 2");
    
    if(0 == (jump = load_sample("sfx/jump.wav")))
        errorExit("While loading sound 3");
    
    if(0 == (playerdead = load_sample("sfx/playerdeath.wav")))
        errorExit("While loading sound 4");
    
    if(0 == (shoot = load_sample("sfx/shoot.wav")))
        errorExit("While loading sound 5");
    
    if(0 == (thud = load_sample("sfx/thud.wav")))
        errorExit("While loading sound 6");
#endif
    
    srand(time(0));
    
    set_color_depth(8);
    
    try {
        
        config.init(GFX_AUTODETECT_FULLSCREEN);
        
    } catch(exception &e) {
        
        errorExit(e.what());
    }
    
    datafile.load();
    dat = datafile.get_datafile();
    set_palette((RGB*)dat[DAT_PAL].dat);
    
    font = (FONT*)dat[DAT_GAMEFONT].dat;

    LOCK_VARIABLE(total_ticks);
    LOCK_VARIABLE(tick_debt);
    LOCK_FUNCTION(ticker);
    
    stopwatch::tickptr = &total_ticks;
    stopwatch::second_factor = running_bps / 6;
    animation::msecs = &msecs;/*
    
    BITMAP *bmp = (BITMAP*)datafile.find("OBJECT/SHADOW0");
    int col = getpixel(bmp, 0, 0);
    for(int x = 0; x < bmp->w; x++)
        for(int y = 0; y < bmp->h; y++)
            if(getpixel(bmp, x, y) == col)
                putpixel(bmp, x, y, bitmap_mask_color(bmp));
    save_bitmap("0.bmp", bmp, (RGB*)dat[DAT_PAL].dat);
            
    BITMAP *bmp1 = (BITMAP*)datafile.find("LEVELCOMPLETE");
    int col1 = getpixel(bmp1, 0, 0);
    for(int x = 0; x < bmp1->w; x++)
        for(int y = 0; y < bmp1->h; y++)
            if(getpixel(bmp1, x, y) == col1)
                putpixel(bmp1, x, y, bitmap_mask_color(bmp1));
    save_bitmap("1.bmp", bmp1, (RGB*)dat[DAT_PAL].dat);
            
    BITMAP *bmp2 = (BITMAP*)datafile.find("TILE2");
    int col2 = getpixel(bmp2, 0, 0);
    for(int x = 0; x < bmp2->w; x++)
        for(int y = 0; y < bmp2->h; y++)
            if(getpixel(bmp2, x, y) == col2)
                putpixel(bmp2, x, y, bitmap_mask_color(bmp2));
    save_bitmap("2.bmp2", bmp2, (RGB*)dat[DAT_PAL].dat);
            
    BITMAP *bmp3 = (BITMAP*)datafile.find("TILE3");
    int col3 = getpixel(bmp3, 0, 0);
    for(int x = 0; x < bmp3->w; x++)
        for(int y = 0; y < bmp3->h; y++)
            if(getpixel(bmp3, x, y) == col3)
                putpixel(bmp3, x, y, bitmap_mask_color(bmp3));
    save_bitmap("3.bmp3", bmp3, (RGB*)dat[DAT_PAL].dat);
            
    BITMAP *bmp4 = (BITMAP*)datafile.find("TILE4");
    int col4 = getpixel(bmp4, 0, 0);
    for(int x = 0; x < bmp4->w; x++)
        for(int y = 0; y < bmp4->h; y++)
            if(getpixel(bmp4, x, y) == col4)
                putpixel(bmp4, x, y, bitmap_mask_color(bmp4));
    save_bitmap("4.bmp4", bmp4, (RGB*)dat[DAT_PAL].dat);
            
    BITMAP *bmp5 = (BITMAP*)datafile.find("TILE5");
    int col5 = getpixel(bmp5, 0, 0);
    for(int x = 0; x < bmp5->w; x++)
        for(int y = 0; y < bmp5->h; y++)
            if(getpixel(bmp5, x, y) == col5)
                putpixel(bmp5, x, y, bitmap_mask_color(bmp5));
    save_bitmap("5.bmp5", bmp5, (RGB*)dat[DAT_PAL].dat);
            
    BITMAP *bmp6 = (BITMAP*)datafile.find("TILE6");
    int col6 = getpixel(bmp6, 0, 0);
    for(int x = 0; x < bmp6->w; x++)
        for(int y = 0; y < bmp6->h; y++)
            if(getpixel(bmp6, x, y) == col6)
                putpixel(bmp6, x, y, bitmap_mask_color(bmp6));
    save_bitmap("6.bmp6", bmp6, (RGB*)dat[DAT_PAL].dat);*/
    
    dumbo_init();
    
    int status = 0;
    
    while(status != -1) {
        
        switch(status) {
            case 0:
                status = mainmenu();
                break;
            case 1:
                status = maingame();
                break;
            case 2:
                status = keyconfig();
                break;
        }
    }
    
    dumbo_exit();
    
    config.shutdown();
    datafile.unload();
}
END_OF_MAIN()
