#ifndef DATAFILE_H
#define DATAFILE_H

#include <string>
#include <map>
#include <allegro.h>
#include "datinfo.h"

extern DATAFILE *dat;

extern class datafile_t {
private:

    DATAFILE *dat;
    std::string filename;
    std::map<void*, DATAFILE*> loadfinds;

public:

    datafile_t(const std::string &filename = "data.dat");

    void set_filename(const std::string&);
    std::string get_filename() const;

    // load and loadfind should be called after the graphics mode is captured (see conf::init)

    bool load();
    void unload();

    void *find(const std::string &objname, DATAFILE **datf = 0);
    void *loadfind(const std::string &objname, DATAFILE **datf = 0);
    void unloadfind(void*);
    
    DATAFILE *get_datafile();
    
} datafile;

#endif
